package ai.digital.deploy.permissions.api.rest.v2

import ai.digital.deploy.permissions.api.rest.dto._
import ai.digital.deploy.permissions.rest.dto.validation.IsUuid

import java.util.{UUID, Set => JSet}
import javax.validation.Valid

trait ExtendedReferencedPermissionsResource {
  def editPermissions(@IsUuid referenceId: String,
                      roleName: String,
                      @Valid editRolePermissionsRequest: EditRolePermissionsRequest
  ): RoleWithReferencedPermissionsDto

  def getReferencesForRole(@Valid dto: GetReferencedPermissionsForRoleIdDto): JSet[UUID]

  def getReferencesForRoleName(@Valid dto: GetReferencedPermissionsForRoleNameDto): JSet[UUID]

  def getReferencesForPrincipal(@Valid dto: GetReferencedPermissionsForPrincipalDto): JSet[UUID]

  def deleteForReference(@IsUuid referenceId: String): Unit

  def deleteAll(): Unit
}
