package ai.digital.deploy.permissions.api.rest.v1

import ai.digital.deploy.permissions.api.rest.dto._
import org.springframework.data.domain.{Page, Pageable}

trait PermissionResource {
  def read(roleName: String): RoleWithPermissionsDto

  def read(roleNames: List[String]): List[RoleWithPermissionsDto]

  def read(roleNames: List[String], pageable: Pageable): Page[RoleWithPermissionsDto]

  def checkPermission(checkPermissionRequest: CheckPermissionRequest): Boolean

  def checkPermission(checkPermissionRequest: CheckPermissionWithPrincipalsRequest): Boolean

  def checkPermission(checkPermissionRequest: CheckPermissionWithReferencesRequest): Map[String, Boolean]

  def checkPermission(checkPermissionRequest: CheckPermissionWithReferencesAndPrincipalsRequest): Map[String, Boolean]
}
