package ai.digital.deploy.permissions.api.rest.v1

import ai.digital.deploy.permissions.api.rest.dto.{PermissionFilterDto, RoleWithReferencedPermissionsDto}
import ai.digital.deploy.permissions.rest.dto.validation.{IsUuid, NonEmptyElements}
import org.hibernate.validator.constraints.UniqueElements
import org.springframework.data.domain.{Page, Pageable}

import java.util.{List => JList}

trait ReferencedPermissionsResource extends {
  def addPermissions(@IsUuid referenceId: String,
                     role: String,
                     @UniqueElements(message = "{permission.added.list.duplicate}")
                     @NonEmptyElements(message = "{permission.listValues.not.empty}")
                     permissions: JList[String]
  ): RoleWithReferencedPermissionsDto

  def removePermissions(@IsUuid referenceId: String,
                        roleName: String,
                        @UniqueElements(message = "{permission.removed.list.duplicate}")
                        @NonEmptyElements(message = "{permission.listValues.not.empty}")
                        permissions: JList[String]
  ): RoleWithReferencedPermissionsDto

  def read(@IsUuid referenceId: String, roleName: String): List[String]

  def read(@IsUuid referenceId: String,
           permissionFilter: PermissionFilterDto,
           pageable: Pageable
  ): Page[RoleWithReferencedPermissionsDto]

  def readByRolePattern(@IsUuid referenceId: String,
                        permissionFilter: PermissionFilterDto
  ): List[RoleWithReferencedPermissionsDto]
}
