package ai.digital.deploy.permissions.api.rest.v1

import ai.digital.deploy.permissions.api.rest.dto.{GetByReferenceIdDto, RoleFilterDto, RoleWithPrincipalsDto}
import ai.digital.deploy.permissions.rest.dto.validation.NonEmptyElements
import org.hibernate.validator.constraints.UniqueElements
import org.springframework.data.domain.{Page, Pageable}

trait RolePrincipalsResource {
  def addPrincipals(roleName: String,
                    @UniqueElements(message = "{principal.added.list.duplicate}")
                    @NonEmptyElements(message = "{principal.listValues.not.empty}")
                    principals: List[String]
  ): RoleWithPrincipalsDto

  def removePrincipals(roleName: String,
                       @UniqueElements(message = "{principal.removed.list.duplicate}")
                       @NonEmptyElements(message = "{principal.listValues.not.empty}")
                       principals: List[String]
  ): RoleWithPrincipalsDto

  def readPrincipals(roleName: String): List[String]

  def readPrincipalsForAllRoles(filter: RoleFilterDto, pageable: Pageable): Page[RoleWithPrincipalsDto]

  def readByRolePattern(filter: RoleFilterDto): List[RoleWithPrincipalsDto]

  def read(principal: String, filter: RoleFilterDto): List[RoleWithPrincipalsDto]

  def read(principals: List[String], filter: RoleFilterDto): List[RoleWithPrincipalsDto]

  def read(principals: List[String], filter: RoleFilterDto, pageable: Pageable): Page[RoleWithPrincipalsDto]
}
