package ai.digital.deploy.permissions.api.rest.v1.impl

import ai.digital.deploy.permissions.api.rest.dto.converters.RoleConverter._
import ai.digital.deploy.permissions.api.rest.dto.{RoleDto, RoleFilterDto}
import ai.digital.deploy.permissions.api.rest.v1.PrincipalRolesPaths._
import ai.digital.deploy.permissions.api.rest.v1.PrincipalRolesResource
import org.springframework.data.domain.{Page, Pageable}
import ai.digital.deploy.permissions.service.RolePrincipalService
import org.springframework.web.bind.annotation.{GetMapping, PathVariable, RequestMapping, RestController}

@RestController
@RequestMapping(Array(BASE_PATH))
class PrincipalRolesController(rolePrincipalService: RolePrincipalService) extends PrincipalRolesResource {
  @GetMapping(Array(READ_PRINCIPAL_ROLES_PATH))
  override def read(@PathVariable principal: String): List[RoleDto] =
    rolePrincipalService.read(principal)
  @GetMapping(Array(READ_PRINCIPAL_ROLES_PATH_BY_PATTERN))
  override def read(@PathVariable principal: String, filter: RoleFilterDto, pageable: Pageable): Page[RoleDto] =
    rolePrincipalService.read(principal, filter.namePattern, pageable)
}
