package ai.digital.deploy.permissions.api.rest.v2.impl

import ai.digital.deploy.permissions.api.rest.dto.converters.RoleConverter._
import ai.digital.deploy.permissions.api.rest.dto.converters.RoleWithPrincipalsConverter.rolePrincipalToDto
import ai.digital.deploy.permissions.api.rest.dto.{EditRolePrincipalsRequest, RoleWithPrincipalsDto}
import ai.digital.deploy.permissions.api.rest.v2.ExtendedRolePrincipalsPaths._
import ai.digital.deploy.permissions.api.rest.v2.ExtendedRolePrincipalsResource
import ai.digital.deploy.permissions.service.RolePrincipalService
import org.springframework.web.bind.annotation._

import javax.validation.Valid
import scala.jdk.CollectionConverters._

@RestController
@RequestMapping(Array(BASE_PATH))
class ExtendedRolePrincipalsController(rolePrincipalService: RolePrincipalService) extends ExtendedRolePrincipalsResource {
  @PatchMapping
  override def editPrincipals(@PathVariable roleName: String,
                              @Valid @RequestBody editRolePrincipalsRequest: EditRolePrincipalsRequest
  ): RoleWithPrincipalsDto = {
    val (role, principals) = rolePrincipalService.edit(
      roleName,
      editRolePrincipalsRequest.addedPrincipals.asScala.toList,
      editRolePrincipalsRequest.removedPrincipals.asScala.toList
    )
    RoleWithPrincipalsDto(role, principals)
  }
}
