package ai.digital.deploy.permissions.api.rest.v2.impl

import ai.digital.deploy.permissions.api.rest.dto.converters.RoleConverter._
import ai.digital.deploy.permissions.api.rest.dto.converters.RoleWithGlobalPermissionsConverter._
import ai.digital.deploy.permissions.api.rest.dto.{EditRolePermissionsRequest, GetGlobalPermissionsForPrincipalNameDto, GetGlobalPermissionsForRoleIdDto, RoleWithGlobalPermissionsDto}
import ai.digital.deploy.permissions.api.rest.v2.ExtendedGlobalPermissionsPaths._
import ai.digital.deploy.permissions.service.GlobalPermissionService
import org.springframework.web.bind.annotation._

import java.util.UUID
import javax.validation.Valid
import scala.jdk.CollectionConverters._

@RestController
@RequestMapping(Array(BASE_PATH))
class ExtendedGlobalPermissionsController(globalPermissionService: GlobalPermissionService) {
  @PatchMapping(Array(EDIT_ROLE_PERMISSIONS_PATH))
  def editPermissions(
    @PathVariable roleName: String,
    @Valid @RequestBody editRolePermissionsRequest: EditRolePermissionsRequest
  ): RoleWithGlobalPermissionsDto = {
    val (role, permissions) = globalPermissionService.edit(
      roleName,
      editRolePermissionsRequest.addedPermissions.asScala.toList,
      editRolePermissionsRequest.removedPermissions.asScala.toList
    )
    RoleWithGlobalPermissionsDto(role, permissions)
  }

  @GetMapping(Array(GET_PERMISSIONS_ROLE_ID))
  def getGlobalPermissionsForRoleId(@Valid dto: GetGlobalPermissionsForRoleIdDto): List[String] =
    globalPermissionService.getGlobalPermissionsForRoleId(UUID.fromString(dto.roleId))

  @GetMapping(Array(GET_PERMISSIONS_PRINCIPAL_NAME))
  def getGlobalPermissionsForPrincipal(@Valid dto: GetGlobalPermissionsForPrincipalNameDto): Set[String] =
    globalPermissionService.getGlobalPermissionsForPrincipal(dto.principalName)

  @DeleteMapping(value = Array(DELETE_ALL_PATH))
  def deleteAll(): Unit =
    globalPermissionService.removeAll()
}
