/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.deploy.permissions.api.rest.v1.impl;

import ai.digital.deploy.permissions.api.rest.dto.CheckPermissionRequest;
import ai.digital.deploy.permissions.api.rest.dto.CheckPermissionWithPrincipalsRequest;
import ai.digital.deploy.permissions.api.rest.dto.CheckPermissionWithReferencesAndPrincipalsRequest;
import ai.digital.deploy.permissions.api.rest.dto.CheckPermissionWithReferencesRequest;
import ai.digital.deploy.permissions.api.rest.dto.PermissionsWithRoleDto;
import ai.digital.deploy.permissions.api.rest.dto.PrincipalsWithPermissionsDto;
import ai.digital.deploy.permissions.api.rest.dto.ReferencedPermissionsDto;
import ai.digital.deploy.permissions.api.rest.dto.RoleWithPermissionsDto;
import ai.digital.deploy.permissions.api.rest.dto.converters.RoleConverter$;
import ai.digital.deploy.permissions.api.rest.dto.converters.RoleWithGlobalPermissionsConverter$;
import ai.digital.deploy.permissions.exception.RoleNameNotFoundException;
import ai.digital.deploy.permissions.model.Role;
import ai.digital.deploy.permissions.service.GlobalPermissionService;
import ai.digital.deploy.permissions.service.ReferencedPermissionService;
import ai.digital.deploy.permissions.service.RoleService;
import java.io.Serializable;
import java.util.UUID;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@RestController
@RequestMapping(value={"/v1/permissions/all"})
@ScalaSignature(bytes="\u0006\u0005\u00055g\u0001\u0002\b\u0010\u0001\u0001B\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\t]\u0001\u0011\t\u0011)A\u0005_!A!\u0007\u0001B\u0001B\u0003%1\u0007C\u00037\u0001\u0011\u0005q\u0007C\u0003>\u0001\u0011\u0005a\bC\u0003>\u0001\u0011\u0005\u0011\u000e\u0003\u0004>\u0001\u0011\u0005\u0011\u0011\u0002\u0005\b\u0003c\u0001A\u0011AA\u001a\u0011\u001d\t\t\u0004\u0001C\u0001\u0003\u001bBq!!\r\u0001\t\u0003\ty\u0006C\u0004\u00022\u0001!\t!a\u001e\t\u000f\u0005%\u0005\u0001\"\u0001\u0002\f\"9\u00111\u0015\u0001\u0005\u0002\u0005\u0015&\u0001\u0006)fe6L7o]5p]\u000e{g\u000e\u001e:pY2,'O\u0003\u0002\u0011#\u0005!\u0011.\u001c9m\u0015\t\u00112#\u0001\u0002wc)\u0011A#F\u0001\u0005e\u0016\u001cHO\u0003\u0002\u0017/\u0005\u0019\u0011\r]5\u000b\u0005aI\u0012a\u00039fe6L7o]5p]NT!AG\u000e\u0002\r\u0011,\u0007\u000f\\8z\u0015\taR$A\u0004eS\u001eLG/\u00197\u000b\u0003y\t!!Y5\u0004\u0001M\u0011\u0001!\t\t\u0003E\u0015j\u0011a\t\u0006\u0002I\u0005)1oY1mC&\u0011ae\t\u0002\u0007\u0003:L(+\u001a4\u0002\u0017I|G.Z*feZL7-\u001a\t\u0003S1j\u0011A\u000b\u0006\u0003W]\tqa]3sm&\u001cW-\u0003\u0002.U\tY!k\u001c7f'\u0016\u0014h/[2f\u0003m\u0011XMZ3sK:\u001cW\r\u001a)fe6L7o]5p]N+'O^5dKB\u0011\u0011\u0006M\u0005\u0003c)\u00121DU3gKJ,gnY3e!\u0016\u0014X.[:tS>t7+\u001a:wS\u000e,\u0017aF4m_\n\fG\u000eU3s[&\u001c8/[8o'\u0016\u0014h/[2f!\tIC'\u0003\u00026U\t9r\t\\8cC2\u0004VM]7jgNLwN\\*feZL7-Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\taR4\b\u0010\t\u0003s\u0001i\u0011a\u0004\u0005\u0006O\u0011\u0001\r\u0001\u000b\u0005\u0006]\u0011\u0001\ra\f\u0005\u0006e\u0011\u0001\raM\u0001\u0005e\u0016\fG\r\u0006\u0002@\u000bB\u0011\u0001iQ\u0007\u0002\u0003*\u0011!iE\u0001\u0004IR|\u0017B\u0001#B\u0005Y\u0011v\u000e\\3XSRD\u0007+\u001a:nSN\u001c\u0018n\u001c8t\tR|\u0007\"\u0002$\u0006\u0001\u00049\u0015\u0001\u0003:pY\u0016t\u0015-\\3\u0011\u0005!{eBA%N!\tQ5%D\u0001L\u0015\tau$\u0001\u0004=e>|GOP\u0005\u0003\u001d\u000e\na\u0001\u0015:fI\u00164\u0017B\u0001)R\u0005\u0019\u0019FO]5oO*\u0011aj\t\u0015\u0003\u000bN\u0003\"\u0001V0\u000e\u0003US!AV,\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002Y3\u0006!!-\u001b8e\u0015\tQ6,A\u0002xK\nT!\u0001X/\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011AX\u0001\u0004_J<\u0017B\u00011V\u00051\u0001\u0016\r\u001e5WCJL\u0017M\u00197fQ\u0011)!-\u001a4\u0011\u0005Q\u001b\u0017B\u00013V\u0005)9U\r^'baBLgnZ\u0001\u0006m\u0006dW/\u001a\u0017\u0002O\u0006\n\u0001.A\u00060wJ|G.\u001a(b[\u0016lHC\u00016t!\rY\u0007o\u0010\b\u0003Y:t!AS7\n\u0003\u0011J!a\\\u0012\u0002\u000fA\f7m[1hK&\u0011\u0011O\u001d\u0002\u0005\u0019&\u001cHO\u0003\u0002pG!)AO\u0002a\u0001k\u0006I!o\u001c7f\u001d\u0006lWm\u001d\t\u0004mn<U\"A<\u000b\u0005aL\u0018\u0001B;uS2T\u0011A_\u0001\u0005U\u00064\u0018-\u0003\u0002ro\"\u00121/ \t\u0003)zL!a`+\u0003\u0019I+\u0017/^3tiB\u000b'/Y7)\u000b\u0019\u0011W-a\u0001-\u0005\u0005\u0015\u0011EAA\u0004\u0003\u0019y#o\u001c7fgR1\u00111BA\u000e\u0003?\u0001R!!\u0004\u0002\u0018}j!!a\u0004\u000b\t\u0005E\u00111C\u0001\u0007I>l\u0017-\u001b8\u000b\u0007\u0005U1,\u0001\u0003eCR\f\u0017\u0002BA\r\u0003\u001f\u0011A\u0001U1hK\")Ao\u0002a\u0001k\"\u001a\u00111D?\t\u000f\u0005\u0005r\u00011\u0001\u0002$\u0005A\u0001/Y4fC\ndW\r\u0005\u0003\u0002\u000e\u0005\u0015\u0012\u0002BA\u0014\u0003\u001f\u0011\u0001\u0002U1hK\u0006\u0014G.\u001a\u0015\u0006\u000f\t,\u00171\u0006\u0017\u0003\u0003[\t#!a\f\u0002\u001b=\u0012x\u000e\\3t_\u0019LG\u000e^3s\u0003=\u0019\u0007.Z2l!\u0016\u0014X.[:tS>tG\u0003BA\u001b\u0003w\u00012AIA\u001c\u0013\r\tId\t\u0002\b\u0005>|G.Z1o\u0011\u001d\ti\u0004\u0003a\u0001\u0003\u007f\tac\u00195fG.\u0004VM]7jgNLwN\u001c*fcV,7\u000f\u001e\t\u0004\u0001\u0006\u0005\u0013bAA\"\u0003\n12\t[3dWB+'/\\5tg&|gNU3rk\u0016\u001cH\u000fK\u0003\tE\u0016\f9\u0005\f\u0002\u0002J\u0005\u0012\u00111J\u0001\u0007_\rDWmY6\u0015\t\u0005U\u0012q\n\u0005\b\u0003{I\u0001\u0019AA)!\r\u0001\u00151K\u0005\u0004\u0003+\n%\u0001J\"iK\u000e\\\u0007+\u001a:nSN\u001c\u0018n\u001c8XSRD\u0007K]5oG&\u0004\u0018\r\\:SKF,Xm\u001d;)\u000b%\u0011W-!\u0017-\u0005\u0005m\u0013EAA/\u0003Ey3\r[3dW>\u0002(/\u001b8dSB\fGn\u001d\u000b\u0005\u0003C\n9\u0007\u0005\u0004I\u0003G:\u0015QG\u0005\u0004\u0003K\n&aA'ba\"9\u0011Q\b\u0006A\u0002\u0005%\u0004c\u0001!\u0002l%\u0019\u0011QN!\u0003I\rCWmY6QKJl\u0017n]:j_:<\u0016\u000e\u001e5SK\u001a,'/\u001a8dKN\u0014V-];fgRDSA\u00032f\u0003cb#!a\u001d\"\u0005\u0005U\u0014!E\u0018sK\u001a,'/\u001a8dKN|3\r[3dWR!\u0011\u0011MA=\u0011\u001d\tid\u0003a\u0001\u0003w\u00022\u0001QA?\u0013\r\ty(\u0011\u00022\u0007\",7m\u001b)fe6L7o]5p]^KG\u000f\u001b*fM\u0016\u0014XM\\2fg\u0006sG\r\u0015:j]\u000eL\u0007/\u00197t%\u0016\fX/Z:uQ\u0015Y!-ZABY\t\t))\t\u0002\u0002\b\u0006arF]3gKJ,gnY3t_\rDWmY60aJLgnY5qC2\u001c\u0018aH4fiB+'/\\5tg&|gn]'baB,GMQ=Qe&t7-\u001b9bYR!\u0011QRAK!\u0011Y\u0007/a$\u0011\u0007\u0001\u000b\t*C\u0002\u0002\u0014\u0006\u0013A\u0004\u0015:j]\u000eL\u0007/\u00197t/&$\b\u000eU3s[&\u001c8/[8og\u0012#x\u000eC\u0004\u0002\u00182\u0001\r!!\u000e\u0002+I,g-\u001a:f]\u000e,G\rU3s[&\u001c8/[8og\"\u001a\u0011QS?)\u000b1\u0011W-!(-\u0005\u0005}\u0015EAAQ\u0003EyS.\u00199qK\u0012|\u0003O]5oG&\u0004\u0018\r\\\u0001!O\u0016$\b+\u001a:nSN\u001c\u0018n\u001c8t\u001b\u0006\u0004\b/\u001a3CsB+'/\\5tg&|g.\u0006\u0002\u0002(B!1\u000e]AU!\r\u0001\u00151V\u0005\u0004\u0003[\u000b%A\u0006)fe6L7o]5p]N<\u0016\u000e\u001e5S_2,G\t^8)\u000b5\u0011W-!--\u0005\u0005M\u0016EAA[\u0003IyS.\u00199qK\u0012|\u0003/\u001a:nSN\u001c\u0018n\u001c8)\r\u0001\tI,ZA`!\r!\u00161X\u0005\u0004\u0003{+&A\u0004*fcV,7\u000f^'baBLgn\u001a\u0017\u0003\u0003\u0003\f#!a1\u0002'=2\u0018g\f9fe6L7o]5p]N|\u0013\r\u001c7)\u0007\u0001\t9\rE\u0002U\u0003\u0013L1!a3V\u00059\u0011Vm\u001d;D_:$(o\u001c7mKJ\u0004")
public class PermissionController {
    private final RoleService roleService;
    private final ReferencedPermissionService referencedPermissionService;
    private final GlobalPermissionService globalPermissionService;

    @GetMapping(value={"/{roleName}"})
    public RoleWithPermissionsDto read(@PathVariable String roleName) {
        List globalPermissions = this.globalPermissionService.read(roleName).map((Function1 & Serializable)x$1 -> x$1.permissionName());
        Map referencedPermissions = this.referencedPermissionService.read(roleName).groupBy((Function1 & Serializable)x$2 -> x$2.reference());
        Role role = (Role)this.roleService.read(roleName).getOrElse((Function0 & Serializable)() -> {
            throw new RoleNameNotFoundException(roleName);
        });
        List referencedPermissionsDto = ((IterableOnceOps)referencedPermissions.map((Function1 & Serializable)rp -> new ReferencedPermissionsDto((UUID)rp._1(), ((List)rp._2()).map((Function1 & Serializable)x$3 -> x$3.permissionName())))).toList();
        return new RoleWithPermissionsDto(RoleConverter$.MODULE$.roleToDto(role), globalPermissions, referencedPermissionsDto);
    }

    @GetMapping(value={"/roles"})
    public List<RoleWithPermissionsDto> read(@RequestParam java.util.List<String> roleNames) {
        Map globalPermissions = this.globalPermissionService.read(CollectionConverters$.MODULE$.ListHasAsScala(roleNames).asScala().toList()).groupBy((Function1 & Serializable)x$4 -> x$4.role().name());
        Map referencedPermissions = this.referencedPermissionService.read(CollectionConverters$.MODULE$.ListHasAsScala(roleNames).asScala().toList()).groupBy((Function1 & Serializable)x$5 -> x$5.role().name());
        List roles = this.roleService.read(CollectionConverters$.MODULE$.ListHasAsScala(roleNames).asScala().toList());
        return roles.map((Function1 & Serializable)role -> {
            Map referencedPermissionsForRole = ((IterableOps)referencedPermissions.getOrElse((Object)role.name(), (Function0 & Serializable)() -> package$.MODULE$.List().empty())).groupBy((Function1 & Serializable)x$6 -> x$6.reference());
            List referencedPermissionsDto = ((IterableOnceOps)referencedPermissionsForRole.map((Function1 & Serializable)rp -> new ReferencedPermissionsDto((UUID)rp._1(), ((List)rp._2()).map((Function1 & Serializable)x$7 -> x$7.permissionName())))).toList();
            return new RoleWithPermissionsDto(RoleConverter$.MODULE$.roleToDto(role), RoleWithGlobalPermissionsConverter$.MODULE$.globalPermissionToDto((List)globalPermissions.getOrElse((Object)role.name(), (Function0 & Serializable)() -> package$.MODULE$.List().empty())), referencedPermissionsDto);
        });
    }

    @GetMapping(value={"/roles/filter"})
    public Page<RoleWithPermissionsDto> read(@RequestParam java.util.List<String> roleNames, Pageable pageable) {
        Page roles = this.roleService.read(CollectionConverters$.MODULE$.ListHasAsScala(roleNames).asScala().toList(), pageable);
        List names = CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)roles).asScala().toList().map((Function1 & Serializable)x$8 -> x$8.name());
        Map globalPermissions = this.globalPermissionService.read(names).groupBy((Function1 & Serializable)x$9 -> x$9.role().name());
        Map referencedPermissions = this.referencedPermissionService.read(names).groupBy((Function1 & Serializable)x$10 -> x$10.role().name());
        List dtos = CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)roles).asScala().toList().map((Function1 & Serializable)role -> {
            Map referencedPermissionsForRole = ((IterableOps)referencedPermissions.getOrElse((Object)role.name(), (Function0 & Serializable)() -> package$.MODULE$.List().empty())).groupBy((Function1 & Serializable)x$11 -> x$11.reference());
            List referencedPermissionsDto = ((IterableOnceOps)referencedPermissionsForRole.map((Function1 & Serializable)rp -> new ReferencedPermissionsDto((UUID)rp._1(), ((List)rp._2()).map((Function1 & Serializable)x$12 -> x$12.permissionName())))).toList();
            return new RoleWithPermissionsDto(RoleConverter$.MODULE$.roleToDto(role), RoleWithGlobalPermissionsConverter$.MODULE$.globalPermissionToDto((List)globalPermissions.getOrElse((Object)role.name(), (Function0 & Serializable)() -> package$.MODULE$.List().empty())), referencedPermissionsDto);
        });
        return new PageImpl(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)dtos).asJava(), pageable, roles.getTotalElements());
    }

    @GetMapping(value={"/check"})
    public boolean checkPermission(CheckPermissionRequest checkPermissionRequest) {
        Option referenceMaybe = Option$.MODULE$.apply((Object)checkPermissionRequest.referenceMaybe());
        return BoxesRunTime.unboxToBoolean((Object)referenceMaybe.map((Function1 & Serializable)referenceId -> BoxesRunTime.boxToBoolean((boolean)this.referencedPermissionService.checkPermission(referenceId, CollectionConverters$.MODULE$.ListHasAsScala(checkPermissionRequest.permissions()).asScala().toList(), CollectionConverters$.MODULE$.ListHasAsScala(checkPermissionRequest.allRoles()).asScala().toList()))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> $this.globalPermissionService.checkPermission(CollectionConverters$.MODULE$.ListHasAsScala(checkPermissionRequest.permissions()).asScala().toList(), CollectionConverters$.MODULE$.ListHasAsScala(checkPermissionRequest.allRoles()).asScala().toList())));
    }

    @GetMapping(value={"/check/principals"})
    public boolean checkPermission(CheckPermissionWithPrincipalsRequest checkPermissionRequest) {
        Option referenceMaybe = Option$.MODULE$.apply((Object)checkPermissionRequest.referenceMaybe());
        return BoxesRunTime.unboxToBoolean((Object)referenceMaybe.map((Function1 & Serializable)referenceId -> BoxesRunTime.boxToBoolean((boolean)this.referencedPermissionService.checkPermission(referenceId, CollectionConverters$.MODULE$.ListHasAsScala(checkPermissionRequest.permissions()).asScala().toList(), CollectionConverters$.MODULE$.ListHasAsScala(checkPermissionRequest.allRoles()).asScala().toList(), CollectionConverters$.MODULE$.ListHasAsScala(checkPermissionRequest.principals()).asScala().toList()))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> $this.globalPermissionService.checkPermission(CollectionConverters$.MODULE$.ListHasAsScala(checkPermissionRequest.permissions()).asScala().toList(), CollectionConverters$.MODULE$.ListHasAsScala(checkPermissionRequest.allRoles()).asScala().toList(), CollectionConverters$.MODULE$.ListHasAsScala(checkPermissionRequest.principals()).asScala().toList())));
    }

    @GetMapping(value={"/references/check"})
    public Map<String, Object> checkPermission(CheckPermissionWithReferencesRequest checkPermissionRequest) {
        return CollectionConverters$.MODULE$.ListHasAsScala(checkPermissionRequest.references()).asScala().toList().isEmpty() ? (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"global"), (Object)BoxesRunTime.boxToBoolean((boolean)this.globalPermissionService.checkPermission(CollectionConverters$.MODULE$.ListHasAsScala(checkPermissionRequest.permissions()).asScala().toList(), CollectionConverters$.MODULE$.ListHasAsScala(checkPermissionRequest.allRoles()).asScala().toList())))})) : CollectionConverters$.MODULE$.ListHasAsScala(checkPermissionRequest.references()).asScala().toList().map((Function1 & Serializable)reference -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)reference.toString()), (Object)BoxesRunTime.boxToBoolean((boolean)$this.referencedPermissionService.checkPermission(reference, CollectionConverters$.MODULE$.ListHasAsScala(checkPermissionRequest.permissions()).asScala().toList(), CollectionConverters$.MODULE$.ListHasAsScala(checkPermissionRequest.allRoles()).asScala().toList())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @GetMapping(value={"/references/check/principals"})
    public Map<String, Object> checkPermission(CheckPermissionWithReferencesAndPrincipalsRequest checkPermissionRequest) {
        return CollectionConverters$.MODULE$.ListHasAsScala(checkPermissionRequest.references()).asScala().toList().isEmpty() ? (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"global"), (Object)BoxesRunTime.boxToBoolean((boolean)this.globalPermissionService.checkPermission(CollectionConverters$.MODULE$.ListHasAsScala(checkPermissionRequest.permissions()).asScala().toList(), CollectionConverters$.MODULE$.ListHasAsScala(checkPermissionRequest.allRoles()).asScala().toList(), CollectionConverters$.MODULE$.ListHasAsScala(checkPermissionRequest.principals()).asScala().toList())))})) : CollectionConverters$.MODULE$.ListHasAsScala(checkPermissionRequest.references()).asScala().toList().map((Function1 & Serializable)reference -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)reference.toString()), (Object)BoxesRunTime.boxToBoolean((boolean)$this.referencedPermissionService.checkPermission(reference, CollectionConverters$.MODULE$.ListHasAsScala(checkPermissionRequest.permissions()).asScala().toList(), CollectionConverters$.MODULE$.ListHasAsScala(checkPermissionRequest.allRoles()).asScala().toList(), CollectionConverters$.MODULE$.ListHasAsScala(checkPermissionRequest.principals()).asScala().toList())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @GetMapping(value={"/mapped/principal"})
    public List<PrincipalsWithPermissionsDto> getPermissionsMappedByPrincipal(@RequestParam boolean referencedPermissions) {
        return referencedPermissions ? this.roleService.readAll().flatMap((Function1 & Serializable)role -> {
            List rolePermissionReferenceList = CollectionConverters$.MODULE$.ListHasAsScala(role.referencedPermissions()).asScala().toList().map((Function1 & Serializable)ref -> new Tuple3((Object)ref.permissionName(), (Object)role.name(), (Object)ref.reference().toString()));
            return CollectionConverters$.MODULE$.ListHasAsScala(role.principals()).asScala().toList().flatMap((Function1 & Serializable)principal -> rolePermissionReferenceList.map((Function1 & Serializable)r -> new PrincipalsWithPermissionsDto(principal.principalName(), (String)r._1(), (String)r._2(), (String)r._3())));
        }) : this.roleService.readAll().flatMap((Function1 & Serializable)role -> role.name().equals("deploy_admin_read_only") ? CollectionConverters$.MODULE$.ListHasAsScala(role.globalPermissions()).asScala().toList().map((Function1 & Serializable)permission -> new PrincipalsWithPermissionsDto(null, permission.permissionName(), role.name(), null)) : CollectionConverters$.MODULE$.ListHasAsScala(role.principals()).asScala().toList().flatMap((Function1 & Serializable)principal -> CollectionConverters$.MODULE$.ListHasAsScala(role.globalPermissions()).asScala().toList().map((Function1 & Serializable)permission -> new PrincipalsWithPermissionsDto(principal.principalName(), permission.permissionName(), role.name(), null))));
    }

    @GetMapping(value={"/mapped/permission"})
    public List<PermissionsWithRoleDto> getPermissionsMappedByPermission() {
        return this.roleService.readAll().flatMap((Function1 & Serializable)role -> CollectionConverters$.MODULE$.ListHasAsScala(role.referencedPermissions()).asScala().toList().map((Function1 & Serializable)permission -> new PermissionsWithRoleDto(permission.permissionName(), role.name(), permission.reference().toString())));
    }

    public PermissionController(RoleService roleService, ReferencedPermissionService referencedPermissionService, GlobalPermissionService globalPermissionService) {
        this.roleService = roleService;
        this.referencedPermissionService = referencedPermissionService;
        this.globalPermissionService = globalPermissionService;
    }
}

