package ai.digital.deploy.permissions.api.rest.v1.impl

import ai.digital.deploy.permissions.api.rest.dto.converters.RoleConverter._
import ai.digital.deploy.permissions.api.rest.dto.converters.RoleWithReferencedPermissionsConverter._
import ai.digital.deploy.permissions.api.rest.dto.{PermissionFilterDto, RoleWithPrincipalsDto, RoleWithReferencedPermissionsDto}
import ai.digital.deploy.permissions.api.rest.v1.ReferencedPermissionsPaths._
import ai.digital.deploy.permissions.exception.RoleNameNotFoundException
import ai.digital.deploy.permissions.rest.dto.validation.{IsUuid, NonEmptyElements}
import ai.digital.deploy.permissions.service.ReferencedPermissionService
import org.hibernate.validator.constraints.UniqueElements
import org.springframework.data.domain.{Page, Pageable}
import org.springframework.validation.annotation.Validated
import org.springframework.web.bind.annotation._

import java.util.{UUID, List => JList}
import scala.jdk.CollectionConverters._

@Validated
@RestController
@RequestMapping(Array(BASE_PATH))
class ReferencedPermissionsController(referencedPermissionService: ReferencedPermissionService) {
  @Deprecated
  @PostMapping(Array(ADD_PERMISSIONS_PATH))
  def addPermissions(@IsUuid @PathVariable referenceId: String,
                     @PathVariable roleName: String,
                     @UniqueElements(message = "{permission.added.list.duplicate}")
                     @NonEmptyElements(message = "{permission.listValues.not.empty}")
                     @RequestBody permissions: JList[String]
  ): RoleWithReferencedPermissionsDto = {
    val uuid = UUID.fromString(referenceId)
    referencedPermissionService.add(uuid, roleName, permissions.asScala.toList) match {
      case Left(exception) => throw RoleNameNotFoundException(exception.name)
      case Right((role, rp)) => RoleWithReferencedPermissionsDto(role, uuid, rp)
    }
  }

  @Deprecated
  @DeleteMapping(Array(REMOVE_PERMISSIONS_PATH))
  def removePermissions(@IsUuid @PathVariable referenceId: String,
                        @PathVariable roleName: String,
                        @UniqueElements(message = "{permission.removed.list.duplicate}")
                        @NonEmptyElements(message = "{permission.listValues.not.empty}")
                        @RequestBody permissions: JList[String]
  ): RoleWithReferencedPermissionsDto = {
    val uuid = UUID.fromString(referenceId)
    referencedPermissionService.remove(uuid, roleName, permissions.asScala.toList) match {
      case Left(exception) => throw RoleNameNotFoundException(exception.name)
      case Right((role, rp)) => RoleWithReferencedPermissionsDto(role, uuid, rp)
    }
  }

  @GetMapping(Array(READ_REFERENCED_ROLE_PERMISSIONS_PATH))
  def read(@IsUuid @PathVariable referenceId: String, @PathVariable roleName: String): List[String] =
    referencedPermissionService.read(UUID.fromString(referenceId), roleName) match {
      case Left(exception) => throw RoleNameNotFoundException(exception.name)
      case Right(rolePermissions) => rolePermissions.map(_.permissionName)
    }

  @GetMapping(Array(READ_REFERENCED_PERMISSIONS))
  def read(@IsUuid @PathVariable referenceId: String,
           permissionFilter: PermissionFilterDto,
           pageable: Pageable
  ): Page[RoleWithReferencedPermissionsDto] = {
    val uuid = UUID.fromString(referenceId)
    roleReferencedPermissionViewToDto(
      uuid,
      pageable,
      referencedPermissionService.read(uuid, permissionFilter.rolePattern, pageable)
    )
  }

  @GetMapping(Array(READ_REFERENCED_PERMISSIONS_BY_ROLE_PATTERN))
  def readByRolePattern(@IsUuid @PathVariable referenceId: String,
                        permissionFilter: PermissionFilterDto
  ): List[RoleWithReferencedPermissionsDto] =
    referencedPermissionService
      .readForRolePattern(UUID.fromString(referenceId), permissionFilter.rolePattern).groupBy(_.role).flatMap {
        case (role, permissions) =>
          val groupByReference = permissions.groupBy(_.reference)
          groupByReference.map {
            case (reference, referencePermissions) =>
              RoleWithReferencedPermissionsDto(role, reference, referencePermissions.map(_.permissionName))
          }
      }.toList
}
