package ai.digital.deploy.permissions.config

import org.springframework.context.MessageSource
import org.springframework.context.annotation.{Bean, Configuration}
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean

@Configuration
class ValidationConfiguration(messageSource: MessageSource) {
  @Bean
  def getValidator: LocalValidatorFactoryBean = {
    val bean = new LocalValidatorFactoryBean
    bean.setValidationMessageSource(messageSource)
    bean
  }
}
