package ai.digital.deploy.permissions.api.rest.dto.validation

import ai.digital.deploy.permissions.rest.dto.validation.NonEmptyElements

import java.util.{List => JList}
import javax.validation.{ConstraintValidator, ConstraintValidatorContext}

class NonEmptyElementsValidator extends ConstraintValidator[NonEmptyElements, JList[String]] {

  override def initialize(nonEmptyFields: NonEmptyElements): Unit = {
    // nothing to init
  }

  override def isValid(objects: JList[String], context: ConstraintValidatorContext): Boolean =
    objects == null || objects.stream.allMatch(nef => nef != null && nef.trim.nonEmpty)
}
