package ai.digital.deploy.autoconfiguration

import com.fasterxml.jackson.databind.ObjectMapper
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule
import com.fasterxml.jackson.module.scala.DefaultScalaModule
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean
import org.springframework.context.annotation.{Bean, Configuration, Primary}

@Configuration
@ConditionalOnMissingBean(name = Array("jacksonConfiguration"))
class PermissionServiceJacksonConfiguration {
  @Bean
  @Primary
  @ConditionalOnMissingBean(Array(classOf[ObjectMapper]))
  def objectMapper: ObjectMapper = {
    val objectMapper = new ObjectMapper()
    objectMapper.registerModule(DefaultScalaModule)
    objectMapper.registerModule(new JavaTimeModule())
    objectMapper
  }
}
