package ai.digital.deploy.permissions.api.rest.pagination

import org.springframework.core.MethodParameter
import org.springframework.data.domain.Page
import org.springframework.http.MediaType
import org.springframework.http.converter.HttpMessageConverter
import org.springframework.http.server.{ServerHttpRequest, ServerHttpResponse}
import org.springframework.web.bind.annotation.RestControllerAdvice
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice

@RestControllerAdvice
class PaginatedResponseAdvice extends ResponseBodyAdvice[Object] {
  override def supports(returnType: MethodParameter, converterType: Class[_ <: HttpMessageConverter[_]]): Boolean =
    classOf[Page[_]].isAssignableFrom(returnType.getParameterType)

  override def beforeBodyWrite(body: Object,
                               returnType: MethodParameter,
                               selectedContentType: MediaType,
                               selectedConverterType: Class[_ <: HttpMessageConverter[_]],
                               request: ServerHttpRequest,
                               response: ServerHttpResponse
  ): Object = {
    val page = body.asInstanceOf[Page[_]]
    response.getHeaders.add(Paging.X_TOTAL_COUNT_HEADER, String.valueOf(page.getTotalElements))
    response.getHeaders.add(Paging.X_PAGE, String.valueOf(page.getNumber + 1))
    response.getHeaders.add(Paging.X_SIZE, String.valueOf(page.getSize))
    response.getHeaders.add(Paging.X_HAS_NEXT_PAGE_HEADER, String.valueOf(page.hasNext))
    page.getContent
  }
}
