package ai.digital.deploy.permissions

import org.springframework.context.MessageSource
import org.springframework.context.i18n.LocaleContextHolder
import org.springframework.stereotype.Component

trait MessageHandler {
  def getMessage(key: String, args: Object*): String
}

@Component
class MessageHandlerImpl(messageSource: MessageSource) extends MessageHandler {
  def getMessage(key: String, args: Object*) = messageSource.getMessage(key, args.toArray, LocaleContextHolder.getLocale)
}
