/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.deploy.permissions.api.rest.v1.impl;

import ai.digital.deploy.permissions.api.rest.dto.CreateRoleRequest;
import ai.digital.deploy.permissions.api.rest.dto.RoleDto;
import ai.digital.deploy.permissions.api.rest.dto.RoleFilterDto;
import ai.digital.deploy.permissions.api.rest.dto.RoleIdRequest;
import ai.digital.deploy.permissions.api.rest.dto.RoleWithPrincipalsDto;
import ai.digital.deploy.permissions.api.rest.dto.UpdateRoleRequest;
import ai.digital.deploy.permissions.api.rest.dto.converters.RoleConverter$;
import ai.digital.deploy.permissions.exception.RoleIdNotFoundException;
import ai.digital.deploy.permissions.exception.RoleNameAlreadyExistsException;
import ai.digital.deploy.permissions.exception.RoleNameNotFoundException;
import ai.digital.deploy.permissions.model.Role;
import ai.digital.deploy.permissions.model.Role$;
import ai.digital.deploy.permissions.service.RoleNameAlreadyExistsServiceException;
import ai.digital.deploy.permissions.service.RoleNameNotFoundServiceException;
import ai.digital.deploy.permissions.service.RoleService;
import jakarta.validation.Valid;
import java.io.Serializable;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import scala.Function0;
import scala.MatchError;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@RestController
@RequestMapping(value={"/v1/roles"})
@ScalaSignature(bytes="\u0006\u0005\t\u0005c\u0001\u0002\u000b\u0016\u0001\u0019B\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\u0006i\u0001!\t!\u000e\u0005\ns\u0001\u0001\r\u00111A\u0005\u0002iB\u0011\u0002\u0012\u0001A\u0002\u0003\u0007I\u0011A#\t\u0013-\u0003\u0001\u0019!A!B\u0013Y\u0004\"B,\u0001\t\u0003A\u0006\"B=\u0001\t\u0003Q\bbBA\u0012\u0001\u0011\u0005\u0011Q\u0005\u0005\b\u0003{\u0001A\u0011AA \u0011\u001d\tY\u0007\u0001C\u0001\u0003[Bq!a!\u0001\t\u0003\t)\tC\u0004\u0002\u0014\u0002!\t!!&\t\u000f\u0005m\u0005\u0001\"\u0001\u0002\u001e\"9\u0011Q\u0016\u0001\u0005\u0002\u0005=\u0006bBAW\u0001\u0011\u0005\u0011\u0011\u0018\u0005\b\u0003C\u0004A\u0011AAr\u0011\u001d\t\u0019\u0010\u0001C\u0001\u0003kDqA!\u0003\u0001\t\u0003\u0011Y\u0001C\u0004\u0003\u001e\u0001!\tAa\b\u0003\u001fI{G.Z:D_:$(o\u001c7mKJT!AF\f\u0002\t%l\u0007\u000f\u001c\u0006\u00031e\t!A^\u0019\u000b\u0005iY\u0012\u0001\u0002:fgRT!\u0001H\u000f\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\u001f?\u0005Y\u0001/\u001a:nSN\u001c\u0018n\u001c8t\u0015\t\u0001\u0013%\u0001\u0004eKBdw.\u001f\u0006\u0003E\r\nq\u0001Z5hSR\fGNC\u0001%\u0003\t\t\u0017n\u0001\u0001\u0014\u0005\u00019\u0003C\u0001\u0015,\u001b\u0005I#\"\u0001\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00051J#AB!osJ+g-A\u0006s_2,7+\u001a:wS\u000e,\u0007CA\u00183\u001b\u0005\u0001$BA\u0019\u001e\u0003\u001d\u0019XM\u001d<jG\u0016L!a\r\u0019\u0003\u0017I{G.Z*feZL7-Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005YB\u0004CA\u001c\u0001\u001b\u0005)\u0002\"B\u0017\u0003\u0001\u0004q\u0013aB2p]R,\u0007\u0010^\u000b\u0002wA\u0011AHQ\u0007\u0002{)\u0011\u0011H\u0010\u0006\u0003\u007f\u0001\u000bqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002\u0003\u0006\u0019qN]4\n\u0005\rk$AE!qa2L7-\u0019;j_:\u001cuN\u001c;fqR\f1bY8oi\u0016DHo\u0018\u0013fcR\u0011a)\u0013\t\u0003Q\u001dK!\u0001S\u0015\u0003\tUs\u0017\u000e\u001e\u0005\b\u0015\u0012\t\t\u00111\u0001<\u0003\rAH%M\u0001\tG>tG/\u001a=uA!\u0012Q!\u0014\t\u0003\u001dVk\u0011a\u0014\u0006\u0003!F\u000b!\"\u00198o_R\fG/[8o\u0015\t\u00116+A\u0004gC\u000e$xN]=\u000b\u0005Qs\u0014!\u00022fC:\u001c\u0018B\u0001,P\u0005%\tU\u000f^8xSJ,G-A\u0004sK\u0006$\u0017\t\u001c7\u0015\u0003e\u00032A\u00172f\u001d\tY\u0006M\u0004\u0002]?6\tQL\u0003\u0002_K\u00051AH]8pizJ\u0011AK\u0005\u0003C&\nq\u0001]1dW\u0006<W-\u0003\u0002dI\n!A*[:u\u0015\t\t\u0017\u0006\u0005\u0002gS6\tqM\u0003\u0002i3\u0005\u0019A\r^8\n\u0005)<'a\u0002*pY\u0016$Eo\u001c\u0015\u0005\r1,h\u000f\u0005\u0002ng6\taN\u0003\u0002Q_*\u0011\u0001/]\u0001\u0005E&tGM\u0003\u0002s}\u0005\u0019q/\u001a2\n\u0005Qt'AC$fi6\u000b\u0007\u000f]5oO\u0006)a/\u00197vK2\nq/I\u0001y\u0003\u0011y\u0013\r\u001c7\u0002\r\r\u0014X-\u0019;f)\t)7\u0010C\u0003}\u000f\u0001\u0007Q0A\tde\u0016\fG/\u001a*pY\u0016\u0014V-];fgR\u0004\"A\u001a@\n\u0005}<'!E\"sK\u0006$XMU8mKJ+\u0017/^3ti\"\u001a10a\u0001\u0011\t\u0005\u0015\u0011qB\u0007\u0003\u0003\u000fQA!!\u0003\u0002\f\u0005Qa/\u00197jI\u0006$\u0018n\u001c8\u000b\u0005\u00055\u0011a\u00026bW\u0006\u0014H/Y\u0005\u0005\u0003#\t9AA\u0003WC2LG\rK\u0002|\u0003+\u00012!\\A\f\u0013\r\tIB\u001c\u0002\f%\u0016\fX/Z:u\u0005>$\u0017\u0010K\u0002\b\u0003;\u00012!\\A\u0010\u0013\r\t\tC\u001c\u0002\f!>\u001cH/T1qa&tw-\u0001\bde\u0016\fG/Z(s+B$\u0017\r^3\u0015\u0007\u0015\f9\u0003C\u0004\u0002*!\u0001\r!a\u000b\u0002#U\u0004H-\u0019;f%>dWMU3rk\u0016\u001cH\u000fE\u0002g\u0003[I1!a\fh\u0005E)\u0006\u000fZ1uKJ{G.\u001a*fcV,7\u000f\u001e\u0015\u0005\u0003O\t\u0019\u0001\u000b\u0003\u0002(\u0005U\u0001F\u0002\u0005\u0002\u001eU\f9\u0004\f\u0002\u0002:\u0005\u0012\u00111H\u0001\u0006_M\fg/Z\u0001\rI\u0016dW\r^3Cs:\u000bW.\u001a\u000b\u0004\r\u0006\u0005\u0003bBA\"\u0013\u0001\u0007\u0011QI\u0001\u0005]\u0006lW\r\u0005\u0003\u0002H\u0005=c\u0002BA%\u0003\u0017\u0002\"\u0001X\u0015\n\u0007\u00055\u0013&\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003#\n\u0019F\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u001bJ\u0003\u0006BA!\u0003/\u00022!\\A-\u0013\r\tYF\u001c\u0002\r!\u0006$\bNV1sS\u0006\u0014G.\u001a\u0015\u0007\u0013\u0005}S/!\u001a\u0011\u00075\f\t'C\u0002\u0002d9\u0014Q\u0002R3mKR,W*\u00199qS:<GFAA4C\t\tI'A\u00040w:\fW.Z?\u0002\u0015\u0011,G.\u001a;f\u0005fLE\rF\u0002G\u0003_Bq!!\u001d\u000b\u0001\u0004\t\u0019(A\u0007s_2,\u0017\n\u001a*fcV,7\u000f\u001e\t\u0004M\u0006U\u0014bAA<O\ni!k\u001c7f\u0013\u0012\u0014V-];fgRDC!a\u001c\u0002\u0004!2!\"a\u0018v\u0003{b#!a \"\u0005\u0005\u0005\u0015AD\u0018jI>Z(o\u001c7f+VLG-`\u0001\u0012I\u0016dW\r^3BY2\u0014v\u000e\\3SK\u001a\u001cHc\u0001$\u0002\b\"9\u00111I\u0006A\u0002\u0005\u0015\u0003\u0006BAD\u0003/BcaCA0k\u00065EFAAHC\t\t\t*A\u00060w:\fW.Z?0C2d\u0017!\u00033fY\u0016$X-\u00117m)\u00051\u0005F\u0002\u0007\u0002`U\fI\nL\u0001x\u0003\u0019)\b\u000fZ1uKR\u0019Q-a(\t\u000f\u0005%R\u00021\u0001\u0002,!\"\u0011qTA\u0002Q\u0011\ty*!\u0006)\u00075\t9\u000bE\u0002n\u0003SK1!a+o\u0005)\u0001V\u000f^'baBLgnZ\u0001\u0005e\u0016\fG\rF\u0002f\u0003cCq!a\u0011\u000f\u0001\u0004\t)\u0005\u000b\u0003\u00022\u0006]\u0003&\u0002\bmk\u0006]FFAA4)\u0019\tY,a3\u0002VB)\u0011QXAdK6\u0011\u0011q\u0018\u0006\u0005\u0003\u0003\f\u0019-\u0001\u0004e_6\f\u0017N\u001c\u0006\u0004\u0003\u000bt\u0014\u0001\u00023bi\u0006LA!!3\u0002@\n!\u0001+Y4f\u0011\u001d\tim\u0004a\u0001\u0003\u001f\faAZ5mi\u0016\u0014\bc\u00014\u0002R&\u0019\u00111[4\u0003\u001bI{G.\u001a$jYR,'\u000f\u0012;p\u0011\u001d\t9n\u0004a\u0001\u00033\f\u0001\u0002]1hK\u0006\u0014G.\u001a\t\u0005\u0003{\u000bY.\u0003\u0003\u0002^\u0006}&\u0001\u0003)bO\u0016\f'\r\\3)\u0005=a\u0017\u0001\u0003:fC\u0012\u0014\u00150\u00133\u0015\t\u0005\u0015\u00181\u001e\t\u0004M\u0006\u001d\u0018bAAuO\n)\"k\u001c7f/&$\b\u000e\u0015:j]\u000eL\u0007/\u00197t\tR|\u0007bBA9!\u0001\u0007\u00111\u000f\u0015\u0005\u0003W\f\u0019\u0001K\u0003\u0011YV\f\t\u0010\f\u0002\u0002\u0000\u00051!/\u001a8b[\u0016$R!ZA|\u0003wDq!a\u0011\u0012\u0001\u0004\t)\u0005\u000b\u0003\u0002x\u0006]\u0003\"\u0002?\u0012\u0001\u0004i\b\u0006BA~\u0003\u0007AC!a?\u0002\u0016!2\u0011#a*v\u0005\u0007a#A!\u0002\"\u0005\t\u001d\u0011AD\u0018|]\u0006lW-`\u0018sK:\fW.Z\u0001\u0006G>,h\u000e\u001e\u000b\u0005\u0005\u001b\u0011\u0019\u0002E\u0002)\u0005\u001fI1A!\u0005*\u0005\u0011auN\\4\t\u000f\u00055'\u00031\u0001\u0002P\"*!\u0003\\;\u0003\u00181\u0012!\u0011D\u0011\u0003\u00057\taaL2pk:$\u0018!\u0005:fC\u0012\u0014\u0015PU8mKB\u000bG\u000f^3s]R\u0019\u0011L!\t\t\u000f\u000557\u00031\u0001\u0002P\"*1\u0003\\;\u0003&1\u0012!qE\u0011\u0003\u0005S\tqa\f4jYR,'\u000fK\u0002\u0001\u0005[\u00012!\u001cB\u0018\u0013\r\u0011\tD\u001c\u0002\u000f%\u0016\u001cHoQ8oiJ|G\u000e\\3sQ\u0019\u0001!QG;\u0003<A\u0019QNa\u000e\n\u0007\tebN\u0001\bSKF,Xm\u001d;NCB\u0004\u0018N\\4-\u0005\tu\u0012E\u0001B \u0003%yc/M\u0018s_2,7\u000f")
public class RolesController {
    private final RoleService roleService;
    @Autowired
    private ApplicationContext context;

    public ApplicationContext context() {
        return this.context;
    }

    public void context_$eq(ApplicationContext x$1) {
        this.context = x$1;
    }

    @GetMapping(value={"/all"})
    public List<RoleDto> readAll() {
        return RoleConverter$.MODULE$.roleToDto(this.roleService.readAll());
    }

    @PostMapping
    public RoleDto create(@Valid @RequestBody CreateRoleRequest createRoleRequest) {
        Either either = this.roleService.create(createRoleRequest.name());
        if (either instanceof Left) {
            Left left = (Left)either;
            RoleNameAlreadyExistsServiceException exception = (RoleNameAlreadyExistsServiceException)left.value();
            throw new RoleNameAlreadyExistsException(exception.name());
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Role result = (Role)right.value();
            return RoleConverter$.MODULE$.roleToDto(result);
        }
        throw new MatchError((Object)either);
    }

    @PostMapping(value={"/save"})
    public RoleDto createOrUpdate(@Valid @RequestBody UpdateRoleRequest updateRoleRequest) {
        Either either = this.roleService.createOrUpdate(Role$.MODULE$.apply(UUID.fromString(updateRoleRequest.id()), updateRoleRequest.name()));
        if (either instanceof Left) {
            Left left = (Left)either;
            RoleNameAlreadyExistsServiceException exception = (RoleNameAlreadyExistsServiceException)left.value();
            throw new RoleNameAlreadyExistsException(exception.name());
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Role result = (Role)right.value();
            return RoleConverter$.MODULE$.roleToDto(result);
        }
        throw new MatchError((Object)either);
    }

    @DeleteMapping(value={"/{name}"})
    public void deleteByName(@PathVariable String name) {
        Either either = this.roleService.delete(name);
        if (either instanceof Left) {
            Left left = (Left)either;
            RoleNameNotFoundServiceException exception = (RoleNameNotFoundServiceException)left.value();
            throw new RoleNameNotFoundException(exception.name());
        }
        if (either instanceof Right) {
            return;
        }
        throw new MatchError((Object)either);
    }

    @DeleteMapping(value={"/id/{roleUuid}"})
    public void deleteById(@Valid RoleIdRequest roleIdRequest) {
        this.roleService.delete(UUID.fromString(roleIdRequest.roleUuid()));
    }

    @DeleteMapping(value={"/{name}/all"})
    public void deleteAllRoleRefs(@PathVariable String name) {
        Either either = this.roleService.deleteAllRoleReferences(name);
        if (either instanceof Left) {
            Left left = (Left)either;
            RoleNameNotFoundServiceException exception = (RoleNameNotFoundServiceException)left.value();
            throw new RoleNameNotFoundException(exception.name());
        }
        if (either instanceof Right) {
            return;
        }
        throw new MatchError((Object)either);
    }

    @DeleteMapping(value={"/all"})
    public void deleteAll() {
        this.roleService.removeAll();
    }

    @PutMapping
    public RoleDto update(@Valid @RequestBody UpdateRoleRequest updateRoleRequest) {
        return RoleConverter$.MODULE$.roleToDto(this.roleService.update(Role$.MODULE$.apply(UUID.fromString(updateRoleRequest.id()), updateRoleRequest.name())));
    }

    @GetMapping(value={"/{name}"})
    public RoleDto read(@PathVariable String name) {
        return RoleConverter$.MODULE$.roleToDto((Role)this.roleService.read(name).getOrElse((Function0 & Serializable)() -> {
            throw new RoleNameNotFoundException(name);
        }));
    }

    @GetMapping
    public Page<RoleDto> read(RoleFilterDto filter, Pageable pageable) {
        return RoleConverter$.MODULE$.roleToDto(this.roleService.read(filter.namePattern(), pageable));
    }

    @GetMapping(value={"/id/{roleUuid}"})
    public RoleWithPrincipalsDto readById(@Valid RoleIdRequest roleIdRequest) {
        return RoleConverter$.MODULE$.roleToRoleWithPrincipalsDto((Role)this.roleService.read(UUID.fromString(roleIdRequest.roleUuid())).getOrElse((Function0 & Serializable)() -> {
            throw new RoleIdNotFoundException(roleIdRequest.roleUuid());
        }));
    }

    @PutMapping(value={"/{name}/rename"})
    public RoleDto rename(@PathVariable String name, @Valid @RequestBody CreateRoleRequest createRoleRequest) {
        Throwable exception;
        boolean bl = false;
        Left left = null;
        Either either = this.roleService.rename(name, createRoleRequest.name());
        if (either instanceof Left) {
            bl = true;
            left = (Left)either;
            Throwable exception2 = (Throwable)left.value();
            if (exception2 instanceof RoleNameNotFoundServiceException) {
                RoleNameNotFoundServiceException roleNameNotFoundServiceException = (RoleNameNotFoundServiceException)exception2;
                throw new RoleNameNotFoundException(roleNameNotFoundServiceException.name());
            }
        }
        if (bl && (exception = (Throwable)left.value()) instanceof RoleNameAlreadyExistsServiceException) {
            RoleNameAlreadyExistsServiceException roleNameAlreadyExistsServiceException = (RoleNameAlreadyExistsServiceException)exception;
            throw new RoleNameAlreadyExistsException(roleNameAlreadyExistsServiceException.name());
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Role result = (Role)right.value();
            return RoleConverter$.MODULE$.roleToDto(result);
        }
        throw new MatchError((Object)either);
    }

    @GetMapping(value={"/count"})
    public long count(RoleFilterDto filter) {
        return this.roleService.count(filter.namePattern());
    }

    @GetMapping(value={"/filter"})
    public List<RoleDto> readByRolePattern(RoleFilterDto filter) {
        return RoleConverter$.MODULE$.roleToDto(this.roleService.readByRolePattern(filter.namePattern()));
    }

    public RolesController(RoleService roleService) {
        this.roleService = roleService;
    }
}

