package ai.digital.deploy.permissions.api.error

import org.springframework.validation.FieldError

case class ValidationError(message: String, fieldErrors: List[FieldErrorDto]) extends BaseError(message)

case class FieldErrorDto(field: String, message: String)

object FieldErrorDto {
  import scala.language.implicitConversions
  implicit def toFieldErrorDto(fieldError: FieldError): FieldErrorDto =
    FieldErrorDto(fieldError.getField, fieldError.getDefaultMessage)

  implicit def toFieldErrorDto(fieldErrors: List[FieldError]): List[FieldErrorDto] = fieldErrors.map(toFieldErrorDto)
}
