package ai.digital.deploy.permissions.api.rest.v1.impl

import ai.digital.deploy.permissions.api.rest.dto.converters.RoleConverter._
import ai.digital.deploy.permissions.api.rest.dto.converters.RoleWithPrincipalsConverter.roleWithPrincipalsToDto
import ai.digital.deploy.permissions.api.rest.dto.{RoleFilterDto, RoleWithPrincipalsDto}
import ai.digital.deploy.permissions.api.rest.v1.RolePrincipalsPaths._
import ai.digital.deploy.permissions.exception.RoleNameNotFoundException
import ai.digital.deploy.permissions.rest.dto.validation.NonEmptyElements
import ai.digital.deploy.permissions.service.RolePrincipalService
import org.hibernate.validator.constraints.UniqueElements
import org.springframework.data.domain.{Page, Pageable}
import org.springframework.validation.annotation.Validated
import org.springframework.web.bind.annotation._

import java.util.{List => JList}
import scala.jdk.CollectionConverters._

@Validated
@RestController
@RequestMapping(Array(BASE_PATH))
class RolePrincipalsController(rolePrincipalService: RolePrincipalService) {
  @Deprecated
  @PostMapping(Array(ADD_PRINCIPALS_PATH))
  def addPrincipals(@PathVariable roleName: String,
                    @UniqueElements(message = "{principal.added.list.duplicate}")
                    @NonEmptyElements(message = "{principal.listValues.not.empty}")
                    @RequestBody principals: JList[String]
  ): RoleWithPrincipalsDto =
    rolePrincipalService.add(roleName, principals.asScala.toList) match {
      case Left(exception) => throw RoleNameNotFoundException(exception.name)
      case Right((role, rolePrincipals)) => RoleWithPrincipalsDto(role, rolePrincipals.map(_.principalName))
    }

  @Deprecated
  @DeleteMapping(Array(REMOVE_PRINCIPALS_PATH))
  def removePrincipals(@PathVariable roleName: String,
                       @UniqueElements(message = "{principal.removed.list.duplicate}")
                       @NonEmptyElements(message = "{principal.listValues.not.empty}")
                       @RequestBody principals: JList[String]
  ): RoleWithPrincipalsDto =
    rolePrincipalService.remove(roleName, principals.asScala.toList) match {
      case Left(exception) => throw RoleNameNotFoundException(exception.name)
      case Right((role, rolePrincipals)) => RoleWithPrincipalsDto(role, rolePrincipals.map(_.principalName))
    }

  @GetMapping(Array(READ_PRINCIPALS_PATH))
  def readPrincipals(@PathVariable roleName: String): List[String] =
    rolePrincipalService.read(roleName) match {
      case Left(exception) => throw RoleNameNotFoundException(exception.name)
      case Right(rolePrincipals) => rolePrincipals.map(_.principalName)
    }

  @GetMapping(Array(READ_PRINCIPALS_PATH_ALL_ROLES))
  def readPrincipalsForAllRoles(filter: RoleFilterDto, pageable: Pageable): Page[RoleWithPrincipalsDto] =
    roleWithPrincipalsToDto(pageable, rolePrincipalService.read(filter.namePattern, pageable))

  @GetMapping(Array(READ_PRINCIPALS_FOR_ROLE_PATTERN))
  def readByRolePattern(filter: RoleFilterDto): List[RoleWithPrincipalsDto] =
    rolePrincipalService.readByRolePattern(filter.namePattern)

  @GetMapping(Array(READ_PRINCIPALS_FOR_PRINCIPAL_AND_ROLE_PATTERN))
  def read(@PathVariable principal: String, filter: RoleFilterDto): List[RoleWithPrincipalsDto] =
    rolePrincipalService.read(principal, filter.namePattern)

  @GetMapping(Array(READ_PRINCIPALS_FOR_PRINCIPALS_AND_ROLE_PATTERN))
  def read(@RequestParam principals: JList[String], filter: RoleFilterDto): List[RoleWithPrincipalsDto] =
    rolePrincipalService.read(principals.asScala.toList, filter.namePattern)

  @GetMapping(Array(READ_PRINCIPALS_FOR_PRINCIPALS_AND_ROLE_PATTERN_WITH_PAGING))
  def read(@RequestParam principals: JList[String], filter: RoleFilterDto, pageable: Pageable): Page[RoleWithPrincipalsDto] =
    rolePrincipalService.read(principals.asScala.toList, filter.namePattern, pageable)
}
