package ai.digital.deploy.permissions.api.rest.dto

import ai.digital.deploy.permissions.rest.dto.validation.IsUuid

import java.beans.BeanProperty
import java.util.UUID
import javax.validation.constraints.{NotEmpty, NotNull}

class PermissionFilterDto {
  @BeanProperty
  var rolePattern: String = ""
}

object PermissionFilterDto {
  def apply(rolePattern: String): PermissionFilterDto = {
    val permission = new PermissionFilterDto
    permission.rolePattern = rolePattern
    permission
  }
}

class CheckPermissionRequest {
  @BeanProperty
  var referenceMaybe: Option[UUID] = None
  @BeanProperty
  @NotNull
  var permissions: List[String] = _
  @BeanProperty
  @NotNull
  var allRoles: List[String] = _
}

object CheckPermissionRequest {
  def apply(referenceMaybe: Option[UUID], permissions: List[String], allRoles: List[String]): CheckPermissionRequest = {
    val check = new CheckPermissionRequest
    check.referenceMaybe = referenceMaybe
    check.permissions = permissions
    check.allRoles = allRoles
    check
  }
}

class CheckPermissionWithPrincipalsRequest {
  @BeanProperty
  var referenceMaybe: Option[UUID] = None
  @BeanProperty
  @NotNull
  var permissions: List[String] = _
  @BeanProperty
  @NotNull
  var allRoles: List[String] = _
  @BeanProperty
  @NotNull
  var principals: List[String] = _
}

object CheckPermissionWithPrincipalsRequest {
  def apply(referenceMaybe: Option[UUID],
            permissions: List[String],
            allRoles: List[String],
            principals: List[String]
  ): CheckPermissionWithPrincipalsRequest = {
    val check = new CheckPermissionWithPrincipalsRequest
    check.referenceMaybe = referenceMaybe
    check.permissions = permissions
    check.allRoles = allRoles
    check.principals = principals
    check
  }
}

class CheckPermissionWithReferencesRequest {
  @BeanProperty
  @NotNull
  var references: List[UUID] = _
  @BeanProperty
  @NotNull
  var permissions: List[String] = _
  @BeanProperty
  @NotNull
  var allRoles: List[String] = _
}

object CheckPermissionWithReferencesRequest {
  def apply(references: List[UUID], permissions: List[String], allRoles: List[String]): CheckPermissionWithReferencesRequest = {
    val check = new CheckPermissionWithReferencesRequest
    check.references = references
    check.permissions = permissions
    check.allRoles = allRoles
    check
  }
}

class CheckPermissionWithReferencesAndPrincipalsRequest {
  @BeanProperty
  @NotNull
  var references: List[UUID] = _
  @BeanProperty
  @NotNull
  var permissions: List[String] = _
  @BeanProperty
  @NotNull
  var allRoles: List[String] = _
  @BeanProperty
  @NotNull
  var principals: List[String] = _
}

object CheckPermissionWithReferencesAndPrincipalsRequest {
  def apply(references: List[UUID],
            permissions: List[String],
            allRoles: List[String],
            principals: List[String]
  ): CheckPermissionWithReferencesAndPrincipalsRequest = {
    val check = new CheckPermissionWithReferencesAndPrincipalsRequest
    check.references = references
    check.permissions = permissions
    check.allRoles = allRoles
    check.principals = principals
    check
  }
}
