package ai.digital.deploy.permissions.api.rest.dto

import ai.digital.deploy.permissions.rest.dto.validation.IsUuid

import java.util.UUID
import javax.validation.constraints.{NotBlank, NotNull}
import scala.beans.BeanProperty

case class RoleDto(id: UUID, name: String)

class CreateRoleRequest {
  @BeanProperty
  @NotBlank(message = "{role.name.not.empty}")
  var name: String = _
}

class UpdateRoleRequest {
  @BeanProperty
  @NotNull(message = "{role.id.not.empty}")
  @IsUuid
  var id: String = _
  @BeanProperty
  @NotBlank(message = "{role.name.not.empty}")
  var name: String = _
}

class RoleIdRequest {
  @BeanProperty
  @NotNull(message = "{role.id.not.empty}")
  @IsUuid
  var roleUuid: String = _
}

object RoleFilterDto {
  def apply(namePattern: String): RoleFilterDto = {
    val dto = new RoleFilterDto
    dto.namePattern = namePattern
    dto
  }
}

class RoleFilterDto {
  @BeanProperty
  var namePattern: String = ""
}

case class RoleWithPrincipalsDto(role: RoleDto, principals: List[String])

case class RoleWithGlobalPermissionsDto(role: RoleDto, permissions: List[String])

case class RoleWithReferencedPermissionsDto(role: RoleDto, reference: UUID, permissions: List[String])

case class RoleWithPermissionsDto(role: RoleDto,
                                  globalPermissions: List[String],
                                  referencePermissions: List[ReferencedPermissionsDto]
)

case class ReferencedPermissionsDto(reference: UUID, permissions: List[String])
