package ai.digital.deploy.permissions.api.rest.dto

import ai.digital.deploy.permissions.rest.dto.validation.IsUuid

import java.util.{List => JList}
import javax.validation.constraints.{NotBlank, NotEmpty, NotNull}
import scala.beans.BeanProperty

abstract class GetReferencedPermissions {
  @BeanProperty
  @NotNull(message = "{permission.list.not.empty}")
  @NotEmpty(message = "{permission.list.not.empty}")
  var permissions: JList[String] = _
}

class GetReferencedPermissionsForRoleIdDto extends GetReferencedPermissions {
  @BeanProperty
  @NotNull
  @IsUuid
  var roleId: String = _
}

class GetReferencedPermissionsForRoleNameDto extends GetReferencedPermissions {
  @BeanProperty
  @NotBlank(message = "{role.name.not.empty}")
  var roleName: String = _
}

class GetReferencedPermissionsForPrincipalDto extends GetReferencedPermissions {
  @BeanProperty
  @NotBlank(message = "{principal.name.not.empty}")
  var principalName: String = _
}

class GetByReferenceIdDto {
  @BeanProperty
  @NotNull
  @IsUuid
  var referenceId: String = _
}
