package ai.digital.deploy.permissions.api.rest.dto.validation

import ai.digital.deploy.permissions.rest.dto.validation.IsUuid

import javax.validation.{ConstraintValidator, ConstraintValidatorContext}

class UuidValidator extends ConstraintValidator[IsUuid, String] {
  private val matchUuid = "^[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}$".r.pattern

  override def initialize(validUuid: IsUuid): Unit = {
    // nothing to init
  }

  override def isValid(uuid: String, cxt: ConstraintValidatorContext): Boolean =
    matchUuid.matcher(uuid).matches()
}
