package ai.digital.deploy.permissions.api.rest.dto

import ai.digital.deploy.permissions.rest.dto.validation.IsUuid

import javax.validation.constraints.{NotBlank, NotNull}
import scala.beans.BeanProperty

class GetRolePrincipalHistoriesForPrincipalNameDto extends TimeRangeDto {
  @BeanProperty
  @NotBlank(message = "{principal.name.not.empty}")
  var principalName: String = _
}

class GetRolePrincipalHistoriesForRoleIdDto extends TimeRangeDto {
  @BeanProperty
  @NotNull
  @IsUuid
  var roleId: String = _
}

class GetRolePrincipalHistoriesForRoleNameDto extends TimeRangeDto {
  @BeanProperty
  @NotBlank(message = "{role.name.not.empty}")
  var roleName: String = _
}

class GetRolePrincipalHistoriesForRolePrincipalIdDto extends TimeRangeDto {
  @BeanProperty
  @NotNull
  @IsUuid
  var rolePrincipalId: String = _
}
