package ai.digital.deploy.permissions.api.rest.dto

import ai.digital.deploy.permissions.rest.dto.validation.IsUuid

import java.beans.BeanProperty
import javax.validation.constraints.{NotBlank, NotNull}

class GetGlobalPermissionHistoriesForPermissionDto extends TimeRangeDto {
  @BeanProperty
  @NotBlank(message = "{permission.name.not.empty}")
  var permissionName: String = _
}

class GetGlobalPermissionHistoriesForGlobalPermissionIdDto extends TimeRangeDto {
  @BeanProperty
  @NotNull
  @IsUuid
  var globalPermissionId: String = _
}

class GetGlobalPermissionHistoriesForRoleIdDto extends TimeRangeDto {
  @BeanProperty
  @NotNull
  @IsUuid
  var roleId: String = _
}

class GetGlobalPermissionHistoriesForRoleNameDto extends TimeRangeDto {
  @BeanProperty
  @NotBlank(message = "{role.name.not.empty}")
  var roleName: String = _
}
