package ai.digital.deploy.permissions.api.rest.dto.converters

import ai.digital.deploy.permissions.api.rest.dto.ReferencedPermissionTimeRangeDto
import ai.digital.deploy.permissions.model.view.ReferencedPermissionHistory
import java.util.{List => JList}
import scala.jdk.CollectionConverters._

object ReferencedPermissionTimeRangeConverter {
  import scala.language.implicitConversions

  implicit def referencedPermissionHistoryToDto(
    referencedPermissionHistory: ReferencedPermissionHistory
  ): ReferencedPermissionTimeRangeDto =
    ReferencedPermissionTimeRangeDto(
      referencedPermissionHistory.reference,
      referencedPermissionHistory.roleId,
      referencedPermissionHistory.permissionName,
      referencedPermissionHistory.startTime,
      referencedPermissionHistory.endTime
    )

  implicit def referencedPermissionHistoryToDto(
    referencedPermissionHistories: List[ReferencedPermissionHistory]
  ): JList[ReferencedPermissionTimeRangeDto] = referencedPermissionHistories.map(referencedPermissionHistoryToDto).asJava
}
