package ai.digital.deploy.permissions.exception

sealed class ResourceNotFoundException(val message: String) extends RuntimeException
case class RoleNotFoundException(override val message: String, name: String) extends ResourceNotFoundException(message)
case class PrincipalNotFoundException(override val message: String, name: String) extends ResourceNotFoundException(message)
case class RoleNameNotFoundException(name: String) extends ResourceNotFoundException(message = "")
case class RoleIdNotFoundException(id: String) extends ResourceNotFoundException(message = "")
