package ai.digital.deploy.permissions.rest.dto.validation;

import ai.digital.deploy.permissions.api.rest.dto.validation.NonEmptyFieldsValidator;

import jakarta.validation.Constraint;
import jakarta.validation.Payload;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static java.lang.annotation.RetentionPolicy.RUNTIME;

@Target({ElementType.FIELD})
@Retention(RUNTIME)
@Constraint(validatedBy = NonEmptyFieldsValidator.class)
public @interface NonEmptyFields {
    String message() default "{error.validation}";
    Class<?>[] groups() default {};
    Class<? extends Payload>[] payload() default {};
}
