package ai.digital.deploy.permissions.api.rest.dto

import ai.digital.deploy.permissions.rest.dto.validation.NonEmptyFields
import org.hibernate.validator.constraints.UniqueElements

import java.util.{Collections, List => JList}
import scala.beans.BeanProperty
import scala.jdk.CollectionConverters._

object EditRolePrincipalsRequest {
  def apply(removedPrincipals: JList[String], addedPrincipals: JList[String]): EditRolePrincipalsRequest = {
    val dto = new EditRolePrincipalsRequest
    dto.addedPrincipals = addedPrincipals
    dto.removedPrincipals = removedPrincipals
    dto
  }

  def apply(removedPrincipals: List[String], addedPrincipals: List[String]): EditRolePrincipalsRequest =
    apply(removedPrincipals.asJava, addedPrincipals.asJava)
}

class EditRolePrincipalsRequest {
  @BeanProperty
  @UniqueElements(message = "{principal.added.list.duplicate}")
  @NonEmptyFields(message = "{principal.listValues.not.empty}")
  var addedPrincipals: JList[String] = Collections.emptyList()

  @BeanProperty
  @UniqueElements(message = "{principal.removed.list.duplicate}")
  var removedPrincipals: JList[String] = Collections.emptyList()
}
