package ai.digital.deploy.permissions.api.rest.dto

import ai.digital.deploy.permissions.rest.dto.validation.IsUuid

import java.beans.BeanProperty
import java.time.LocalDateTime
import java.util.{List => JList, UUID}
import jakarta.validation.constraints.{NotBlank, NotEmpty, NotNull}

case class ReferencedPermissionTimeRangeDto(reference: UUID,
                                            roleId: UUID,
                                            permissionName: String,
                                            startTime: LocalDateTime,
                                            endTime: LocalDateTime
)

abstract class GetReferencedPermissionTimeRange extends TimeRangeDto {
  @BeanProperty
  @NotNull(message = "{permission.list.not.empty}")
  @NotEmpty(message = "{permission.list.not.empty}")
  var permissions: JList[String] = _
}

class GetReferencedPermissionTimeRangeByRole extends GetReferencedPermissionTimeRange {
  @BeanProperty
  @NotNull
  @IsUuid
  var roleId: String = _
}

class GetReferencedPermissionTimeRangeByPrincipal extends GetReferencedPermissionTimeRange {
  @BeanProperty
  @NotBlank(message = "{principal.name.not.empty}")
  var principalName: String = _
}

trait GetReferencedPermissionByReference {
  @BeanProperty
  @NotNull
  @IsUuid
  var reference: String = _
}

class GetReferencedPermissionTimeRangeByRoleAndRef
    extends GetReferencedPermissionTimeRangeByRole
    with GetReferencedPermissionByReference

class GetReferencedPermissionTimeRangeByPrincipalAndRef
    extends GetReferencedPermissionTimeRangeByPrincipal
    with GetReferencedPermissionByReference

class GetReferenceHistoriesByPermissionName extends GetReferencedPermissionByReference with TimeRangeDto {
  @BeanProperty
  @NotBlank(message = "{permission.name.not.empty}")
  var permissionName: String = _
}
class GetReferenceHistoriesByReferencedPermissionId extends GetReferencedPermissionByReference with TimeRangeDto {
  @BeanProperty
  @NotNull
  @IsUuid
  var referencedPermissionId: String = _
}
class GetReferenceHistoriesByRoleId {
  @BeanProperty
  @NotNull
  @IsUuid
  var roleId: String = _
}
class GetReferenceHistoriesRoleName {
  @BeanProperty
  @NotBlank(message = "{role.name.not.empty}")
  var roleName: String = _
}
class GetReferenceHistoriesByRoleIdTimeRange
    extends GetReferenceHistoriesByRoleId
    with GetReferencedPermissionByReference
    with TimeRangeDto
