package ai.digital.deploy.permissions.api.rest.dto.validation

import ai.digital.deploy.permissions.rest.dto.validation.IsUuids

import java.util.{List => JList}
import jakarta.validation.{ConstraintValidator, ConstraintValidatorContext}
import scala.jdk.CollectionConverters._

class UuidListValidator extends ConstraintValidator[IsUuids, JList[String]] {

  override def initialize(validUuids: IsUuids): Unit = {
    // nothing to init
  }

  override def isValid(uuids: JList[String], cxt: ConstraintValidatorContext): Boolean =
    uuids.asScala.forall(uuid => UuidValidator.matchUuid.matcher(uuid).matches())
}
