package ai.digital.deploy.permissions.api.rest.dto

import ai.digital.deploy.permissions.rest.dto.validation.{IsUuid, IsUuids}

import java.util.{List => JList}
import jakarta.validation.constraints.{NotBlank, NotEmpty, NotNull}
import scala.beans.BeanProperty

abstract class GetReferencedPermissions {
  final protected val ListNotEmptyLabel = "{permission.list.not.empty}"
  final protected val RoleNameNotEmptyLabel = "{role.name.not.empty}"
  final protected val PrincipalNotEmptyLabel = "{principal.name.not.empty}"

  @BeanProperty
  @NotNull(message = ListNotEmptyLabel)
  @NotEmpty(message = ListNotEmptyLabel)
  var permissions: JList[String] = _
}

class GetReferencedPermissionsForRoleIdDto extends GetReferencedPermissions {
  @BeanProperty
  @NotNull
  @IsUuid
  var roleId: String = _
}

class GetReferencedPermissionsForRoleIdsDto extends GetReferencedPermissions {

  @BeanProperty
  @NotNull(message = ListNotEmptyLabel)
  @NotEmpty(message = ListNotEmptyLabel)
  @IsUuids
  var roleIds: JList[String] = _
}

class GetReferencedPermissionsForRoleNameDto extends GetReferencedPermissions {
  @BeanProperty
  @NotBlank(message = RoleNameNotEmptyLabel)
  var roleName: String = _
}

class GetReferencedPermissionsForPrincipalDto extends GetReferencedPermissions {
  @BeanProperty
  @NotBlank(message = PrincipalNotEmptyLabel)
  var principalName: String = _
}

class GetByReferenceIdDto {
  @BeanProperty
  @NotNull
  @IsUuid
  var referenceId: String = _
}
