package ai.digital.deploy.permissions.api.rest.dto

import org.springframework.format.annotation.DateTimeFormat

import java.beans.BeanProperty
import java.time.LocalDateTime
import jakarta.validation.constraints.NotNull

trait TimeRangeDto {
  @BeanProperty
  @NotNull(message = "{startTime.not.null}")
  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  var startTime: LocalDateTime = _

  @BeanProperty
  @NotNull(message = "{endTime.not.null}")
  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  var endTime: LocalDateTime = _
}
