package ai.digital.deploy.permissions.api.rest.dto

import org.hibernate.validator.constraints.UniqueElements

import java.util.{Collections, List => JList}
import scala.beans.BeanProperty
import scala.jdk.CollectionConverters._

object EditRolePermissionsRequest {
  def apply(removedPermissions: JList[String], addedPermissions: JList[String]): EditRolePermissionsRequest = {
    val dto = new EditRolePermissionsRequest
    dto.removedPermissions = removedPermissions
    dto.addedPermissions = addedPermissions
    dto
  }

  def apply(removedPermissions: List[String], addedPermissions: List[String]): EditRolePermissionsRequest =
    apply(removedPermissions.asJava, addedPermissions.asJava)
}

class EditRolePermissionsRequest {
  @BeanProperty
  @UniqueElements(message = "{permission.added.list.duplicate}")
  var addedPermissions: JList[String] = Collections.emptyList()

  @BeanProperty
  @UniqueElements(message = "{permission.removed.list.duplicate}")
  var removedPermissions: JList[String] = Collections.emptyList()
}
