package ai.digital.deploy.permissions.api.rest.dto.validation

import ai.digital.deploy.permissions.rest.dto.validation.IsUuid

import jakarta.validation.{ConstraintValidator, ConstraintValidatorContext}

object UuidValidator {
  val matchUuid = "^[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}$".r.pattern
}

class UuidValidator extends ConstraintValidator[IsUuid, String] {

  override def initialize(validUuid: IsUuid): Unit = {
    // nothing to init
  }

  override def isValid(uuid: String, cxt: ConstraintValidatorContext): Boolean = UuidValidator.matchUuid.matcher(uuid).matches()
}
