package ai.digital.deploy.permissions.api.rest.dto

import ai.digital.deploy.permissions.rest.dto.validation.IsUuid

import jakarta.validation.constraints.{NotBlank, NotNull}
import scala.beans.BeanProperty

class GetGlobalPermissionsForRoleIdDto {
  @BeanProperty
  @NotNull
  @IsUuid
  var roleId: String = _
}

class GetGlobalPermissionsForPrincipalNameDto {
  @BeanProperty
  @NotBlank(message = "{principal.name.not.empty}")
  var principalName: String = _
}
