package ai.digital.deploy.permissions.api.rest.dto

import ai.digital.deploy.permissions.rest.dto.validation.IsUuid

import java.beans.BeanProperty
import jakarta.validation.constraints.NotNull
import java.util.{List => JList, UUID}

class PermissionFilterDto {
  @BeanProperty
  var rolePattern: String = ""
}

object PermissionFilterDto {
  def apply(rolePattern: String): PermissionFilterDto = {
    val permission = new PermissionFilterDto
    permission.rolePattern = rolePattern
    permission
  }
}

class CheckPermissionRequest {
  @BeanProperty
  @IsUuid
  var referenceMaybe: UUID = _
  @BeanProperty
  @NotNull
  var permissions: JList[String] = _
  @BeanProperty
  @NotNull
  var allRoles: JList[String] = _
}

object CheckPermissionRequest {
  def apply(referenceMaybe: UUID, permissions: JList[String], allRoles: JList[String]): CheckPermissionRequest = {
    val check = new CheckPermissionRequest
    check.referenceMaybe = referenceMaybe
    check.permissions = permissions
    check.allRoles = allRoles
    check
  }
}

class CheckPermissionWithPrincipalsRequest {
  @BeanProperty
  @IsUuid
  var referenceMaybe: UUID = _
  @BeanProperty
  @NotNull
  var permissions: JList[String] = _
  @BeanProperty
  @NotNull
  var allRoles: JList[String] = _
  @BeanProperty
  @NotNull
  var principals: JList[String] = _
}

object CheckPermissionWithPrincipalsRequest {
  def apply(referenceMaybe: UUID,
            permissions: JList[String],
            allRoles: JList[String],
            principals: JList[String]
  ): CheckPermissionWithPrincipalsRequest = {
    val check = new CheckPermissionWithPrincipalsRequest
    check.referenceMaybe = referenceMaybe
    check.permissions = permissions
    check.allRoles = allRoles
    check.principals = principals
    check
  }
}

class CheckPermissionWithReferencesRequest {
  @BeanProperty
  @NotNull
  var references: JList[UUID] = _
  @BeanProperty
  @NotNull
  var permissions: JList[String] = _
  @BeanProperty
  @NotNull
  var allRoles: JList[String] = _
}

object CheckPermissionWithReferencesRequest {
  def apply(references: JList[UUID],
            permissions: JList[String],
            allRoles: JList[String]
  ): CheckPermissionWithReferencesRequest = {
    val check = new CheckPermissionWithReferencesRequest
    check.references = references
    check.permissions = permissions
    check.allRoles = allRoles
    check
  }
}

class CheckPermissionWithReferencesAndPrincipalsRequest {
  @BeanProperty
  @NotNull
  var references: JList[UUID] = _
  @BeanProperty
  @NotNull
  var permissions: JList[String] = _
  @BeanProperty
  @NotNull
  var allRoles: JList[String] = _
  @BeanProperty
  @NotNull
  var principals: JList[String] = _
}

object CheckPermissionWithReferencesAndPrincipalsRequest {
  def apply(references: JList[UUID],
            permissions: JList[String],
            allRoles: JList[String],
            principals: JList[String]
  ): CheckPermissionWithReferencesAndPrincipalsRequest = {
    val check = new CheckPermissionWithReferencesAndPrincipalsRequest
    check.references = references
    check.permissions = permissions
    check.allRoles = allRoles
    check.principals = principals
    check
  }
}
