package com.xebialabs.deployit.plugin.steps

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext
import com.xebialabs.overthere.OverthereFile
import com.xebialabs.overthere.util.OverthereUtils
import com.xebialabs.xlplatform.sugar.ResourcesSugar

import java.io.InputStream
import java.net.URL

trait CopyFileSupport extends ResourcesSugar {
  self: TargetHostSupport =>

  private[steps] def mkTargetDirsIfRequired(targetFile: OverthereFile, createTargetPath: Boolean = true)(implicit ctx: ExecutionContext, targetHostEnvironment: HostEnvironment): Unit = {
    val targetDirectory: OverthereFile = targetFile.getParentFile
    if (!targetDirectory.exists()) {
      if (createTargetPath) {
        logOutput(ctx, s"Creating path ${targetDirectory.getPath} on host $targetHost")
        targetDirectory.mkdirs()
      } else {
        ctx.logError(s"Path ${targetDirectory.getPath} on host $targetHost does not exist.")
        throw ExitStep
      }
    }
  }

  private[steps] def deleteTargetFileIfPresent(targetFile: OverthereFile)(implicit ctx: ExecutionContext, targetHostEnvironment: HostEnvironment): Unit = if (targetFile.exists()) {
    logOutput(ctx, s"Deleting ${targetFile.getPath} since it already exists on host $targetHost")
    targetFile.deleteRecursively()
  }

  private[steps] def copyFileToTarget(sourceFile: OverthereFile, targetFile: OverthereFile)(implicit ctx: ExecutionContext, targetHostEnvironment: HostEnvironment): Unit = {
    logOutput(ctx, s"Copying ${sourceFile.getPath} to ${targetFile.getPath} on host $targetHost")
    sourceFile.copyTo(targetFile)
  }

  private[steps] def copyUrlToTarget(url: URL, targetFile: OverthereFile)(implicit ctx: ExecutionContext, targetHostEnvironment: HostEnvironment): Unit = {
    logOutput(ctx, s"Copying resource $url to ${targetFile.getPath} on host $targetHost")
    val inputStream: InputStream = url.openStream()
    try {
      OverthereUtils.write(inputStream, targetFile)
    } finally {
      inputStream.close()
    }
  }

  private[steps] case object ExitStep extends Exception

}
