package com.xebialabs.deployit.plugin.cmd.whitelist.validator;

import com.xebialabs.deployit.engine.tasker.query.RemoteServerQueryHandler;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import scala.util.Left;
import scala.util.Right;

import java.io.IOException;
import java.io.Serializable;

public class RemoteCommandWhitelistValidator implements CommandWhitelistValidator {

    @Override
    public void validate(final String user, final String cmd) throws IOException {
        Serializable result = doRemoteQuery(user, cmd, SecurityContextHolder.getContext().getAuthentication());
        if (result != null) {
            processResult(result);
        } else {
            throw new IllegalArgumentException("Cannot handle query response null");
        }
    }

    private void processResult(Serializable result) throws IOException {
        if (result instanceof Left) {
            Exception ex = (Exception) ((Left) result).value();
            if (ex instanceof IOException) {
                throw (IOException) ex;
            } else if (ex instanceof RuntimeException) {
                throw (RuntimeException) ex;
            }
        } else if (!(result instanceof Right)) {
            throw new IllegalArgumentException("Cannot handle query response [" + result + "]");
        }
    }

    protected Serializable doRemoteQuery(final String user, final String cmd, final Authentication authentication) {
        return RemoteServerQueryHandler.query(new CommandWhitelistPayload(user, cmd, authentication), true);
    }
}
