/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.cmd.whitelist.validator;

import ai.digital.configuration.central.deploy.CommandWhitelistProperties;
import ai.digital.configuration.central.deploy.Roles;
import com.xebialabs.deployit.engine.tasker.query.QueryExecutor;
import com.xebialabs.deployit.engine.tasker.query.QueryExecutorHandler;
import com.xebialabs.deployit.plugin.cmd.whitelist.exception.CommandWhitelistException;
import com.xebialabs.deployit.plugin.cmd.whitelist.validator.CommandWhitelistPayload;
import com.xebialabs.deployit.plugin.cmd.whitelist.validator.CommandWhitelistValidator;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.springframework.security.core.context.SecurityContextHolder;
import scala.util.Left;
import scala.util.Right;

public class LocalCommandWhitelistValidator
implements CommandWhitelistValidator,
QueryExecutor {
    private final CommandWhitelistProperties commandWhitelistProperties;
    private final RoleService roleService;

    public LocalCommandWhitelistValidator(CommandWhitelistProperties commandWhitelistProperties, RoleService roleService) {
        this.commandWhitelistProperties = commandWhitelistProperties;
        this.roleService = roleService;
    }

    @Override
    public void validate(String user, String cmd) {
        if (this.commandWhitelistProperties == null) {
            return;
        }
        if (this.commandWhitelistProperties.enabled()) {
            ArrayList<String> allAllowed = new ArrayList<String>(this.commandWhitelistProperties.allUsers().allowedCommands());
            ArrayList<String> allRestricted = new ArrayList<String>(this.commandWhitelistProperties.allUsers().restrictedCommands());
            this.validateCommandsForAllUsers(allAllowed, allRestricted, cmd);
            List userRoles = this.roleService.getRolesFor(user);
            if (userRoles.isEmpty()) {
                userRoles = this.roleService.getRolesFor(SecurityContextHolder.getContext().getAuthentication());
            }
            for (Role userRole : userRoles) {
                if (!this.commandWhitelistProperties.roles().stream().anyMatch(role -> role.roleName().equals(userRole.getName()))) continue;
                Roles roleRule = this.commandWhitelistProperties.roles().stream().filter(role -> role.roleName().equals(userRole.getName())).findFirst().orElse(new Roles());
                this.validateCommandsForCurrentUser(roleRule, cmd);
                allAllowed.addAll(roleRule.allowedCommands());
                allRestricted.addAll(roleRule.restrictedCommands());
            }
            this.validateWhitelisted(allAllowed, allRestricted, cmd);
        }
    }

    public Serializable query(QueryExecutorHandler.QueryPayload payload) {
        CommandWhitelistPayload commandWhitelistPayload = (CommandWhitelistPayload)payload;
        try {
            this.validate(commandWhitelistPayload.getUser(), commandWhitelistPayload.getCmd());
            return Right.apply((Object)true);
        }
        catch (Exception e) {
            return Left.apply((Object)e);
        }
    }

    private void validateWhitelisted(List<String> allAllowed, List<String> allRestricted, String cmd) {
        if (!allAllowed.isEmpty() && !allRestricted.isEmpty()) {
            throw new CommandWhitelistException("Both allowed commands and restricted commands specified. Please set only one of those properties.");
        }
        if (!allAllowed.isEmpty() && allAllowed.stream().noneMatch(regex -> Pattern.matches(regex, cmd))) {
            throw new CommandWhitelistException("Command " + cmd + " is not whitelisted in allowed-commands.");
        }
    }

    private void validateCommandsForCurrentUser(Roles roleRule, String cmd) {
        String roleName = roleRule.roleName();
        List allowed = roleRule.allowedCommands();
        List restricted = roleRule.restrictedCommands();
        if (!allowed.isEmpty() && !restricted.isEmpty()) {
            throw new CommandWhitelistException("Both allowed commands and restricted commands specified for role " + roleName + ". Please set only one of those properties.");
        }
        if (!restricted.isEmpty()) {
            restricted.forEach(regex -> {
                if (Pattern.matches(regex, cmd)) {
                    throw new CommandWhitelistException("Command " + cmd + " is restricted for role " + roleName + " by rule " + regex);
                }
            });
        }
    }

    private void validateCommandsForAllUsers(List<String> allowed, List<String> restricted, String cmd) {
        if (!allowed.isEmpty() && !restricted.isEmpty()) {
            throw new CommandWhitelistException("Both allowed commands and restricted commands specified for all users. Please set only one of those properties.");
        }
        if (!restricted.isEmpty()) {
            restricted.forEach(regex -> {
                if (Pattern.matches(regex, cmd)) {
                    throw new CommandWhitelistException("Command " + cmd + " is restricted by rule " + regex + " for all users.");
                }
            });
        }
    }
}

