package com.xebialabs.deployit.plugin.generic.step;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.generic.freemarker.ArtifactUploader;
import com.xebialabs.deployit.plugin.overthere.HostContainer;

import java.util.Map;

@SuppressWarnings("serial")
public class ScriptExecutionStep extends BaseExecutionStep {

    @SuppressWarnings("unused")
    public ScriptExecutionStep() {
    }

    public ScriptExecutionStep(int order, String scriptPath, HostContainer container, Map<String, Object> vars, String description) {
        super(order, scriptPath, container, vars, description);
    }

    @Override
    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        return handleExecute(ctx);
    }

    @Override
    public String evaluateTemplate(String templatePath, Map<String, Object> vars, boolean maskPasswords) {
        final ArtifactUploader artifactUploader = getArtifactUploader();
        if (getDerivedArtifact() != null) {
            artifactUploader.upload(getDerivedArtifact());
        }
        return evaluateTemplate(templatePath, vars, maskPasswords, artifactUploader);
    }
}
