package com.xebialabs.deployit.plugin.generic.ci;

import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.overthere.Host;

import static com.xebialabs.deployit.checks.Checks.checkArgument;
import static java.lang.String.format;

@SuppressWarnings("serial")
@Metadata(virtual = true, description = "A container that is nested with another container")
public class NestedContainer extends BaseGenericContainer implements GenericContainer {

    @SuppressWarnings("unchecked")
    @Override
    public <T extends GenericContainer> T getParentContainer() {
        Descriptor descriptor = DescriptorRegistry.getDescriptor(getType());
        for (PropertyDescriptor pd : descriptor.getPropertyDescriptors()) {
            if (pd.getKind() == PropertyKind.CI && pd.isAsContainment()) {
                checkArgument(pd.getReferencedType().instanceOf(Type.valueOf("generic.Container")) || pd.getReferencedType().instanceOf(Type.valueOf("generic.NestedContainer")),
                    "Nested container [%s] of type [%s] has a parent (as-containment) relationship to a type that is not a generic (nested) container but a [%s]", this, getType(), pd.getReferencedType());
                return (T) pd.get(this);
            }
        }
        throw new IllegalStateException(format("Nested container [%s] of type [%s] does not have a parent (as-containment) relationship to another generic (nested) container.", this, getType()));
    }

    @Override
    public Host getHost() {
        return getParentContainer().getHost();
    }

}
