/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.step;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.io.SourceArtifactFile;
import com.xebialabs.deployit.io.copy.CopyUtil;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployableFolderArtifact;
import com.xebialabs.deployit.plugin.generic.step.BaseFolderDeploymentStepSupport;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OverthereExecutionOutputHandler;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.local.LocalFile;
import java.io.File;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtifactDeleteStep
extends BaseFolderDeploymentStepSupport {
    private static final Logger logger = LoggerFactory.getLogger(ArtifactDeleteStep.class);
    private String targetDirectory;
    private DeployableArtifact artifact;
    private String targetFile;
    private boolean targetDirectoryShared;
    private boolean targetPathSharedSubDirectories;
    private Set<String> deleteAdditionalTargetFiles = Sets.newHashSet();

    public ArtifactDeleteStep() {
    }

    public ArtifactDeleteStep(int order, HostContainer container, DeployableArtifact artifact, String targetDirectory) {
        super(order, container);
        this.artifact = artifact;
        this.targetDirectory = Objects.requireNonNull(targetDirectory);
    }

    public ArtifactDeleteStep(int order, HostContainer container, String targetDirectory) {
        this(order, container, null, targetDirectory);
    }

    @Override
    protected StepExitCode doExecute() throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("Starting doExecute. artifact: {}, targetDirectory: {}, targetFile: {}", new Object[]{this.artifact != null ? this.artifact.getName() : null, this.targetDirectory, this.targetFile});
        }
        if (this.artifact != null) {
            this.deleteArtifact();
        } else {
            this.deleteTargetFile();
        }
        this.deleteAdditionalFiles(this.getDeleteAdditionalTargetFiles());
        return StepExitCode.SUCCESS;
    }

    protected void deleteArtifact() {
        if (logger.isDebugEnabled()) {
            logger.debug("deleteArtifact called. artifact: {}, targetDirectory: {}", (Object)(this.artifact != null ? this.artifact.getName() : null), (Object)this.targetDirectory);
        }
        OverthereFile localFile = this.artifact.getFile();
        OverthereFile remoteDir = this.getRemoteConnection().getFile(this.targetDirectory);
        if (localFile.isDirectory()) {
            if (this.targetDirectoryShared) {
                this.deleteFilesAndFoldersForTargetShared(remoteDir, localFile);
            } else {
                logger.debug("[ArtifactDeleteStep] targetDirectoryShared is false, deleting remoteDir. remoteDir: {}", (Object)remoteDir.getPath());
                this.deleteFile(remoteDir);
            }
        } else {
            String name = Strings.nullToEmpty((String)this.targetFile).trim().isEmpty() ? this.artifact.getName() : this.targetFile;
            logger.debug("Artifact is not a directory, deleting file: {}", (Object)name);
            this.deleteFile(remoteDir.getFile(name));
        }
    }

    protected void deleteFilesAndFoldersForTargetShared(OverthereFile remoteDir, OverthereFile localFile) {
        BaseDeployableFolderArtifact baseDeployableFolderArtifact = this.getBaseDeployableFolderArtifact();
        if (this.isTypeIsFileFolder(baseDeployableFolderArtifact) && !this.isOneByOneCopyStrategy()) {
            logger.debug("[ArtifactDeleteStep] Artifact is a directory shared. isDeployableFolderArtifact: {}, isOneByOneCopyStrategy: {}", (Object)this.isDeployableFolderArtifact(), (Object)this.isOneByOneCopyStrategy());
            int stripComponents = this.artifact.hasProperty("stripComponents") ? Integer.parseInt(this.artifact.getProperty("stripComponents").toString()) : 0;
            Set members = this.artifact.hasProperty("members") ? (Set)this.artifact.getProperty("members") : null;
            logger.debug("[ArtifactDeleteStep] targetDirectoryShared is true. stripComponents: {}, members: {}", (Object)stripComponents, (Object)members);
            if (this.isFolderCanBeDeletedRecursive() && !this.targetPathSharedSubDirectories) {
                this.deleteOnlyRootFilesAndFoldersRecursiveOnTar(stripComponents, members, remoteDir, localFile);
            } else {
                logger.debug("[ArtifactDeleteStep] deleteFilesAndFolderOnTar recursive delete slower for isDeployableFolderArtifact: {}, isOneByOneCopyStrategy: {} isFileFolder {} targetPathSharedSubDirectories {}", new Object[]{this.isDeployableFolderArtifact(), this.isOneByOneCopyStrategy(), this.isTypeIsFileFolder(baseDeployableFolderArtifact), this.targetPathSharedSubDirectories});
                this.deleteFilesAndFolderOnTar(stripComponents, members, remoteDir, localFile);
            }
        } else {
            logger.debug("[ArtifactDeleteStep] deleteRemoteDir for isDeployableFolderArtifact: {}, isOneByOneCopyStrategy: {} isFileFolder {}", new Object[]{this.isDeployableFolderArtifact(), this.isOneByOneCopyStrategy(), this.isTypeIsFileFolder(baseDeployableFolderArtifact)});
            this.deleteRemoteDirectory(localFile, remoteDir);
        }
    }

    protected void deleteFilesAndFolderOnTar(int stripComponents, Set<String> members, OverthereFile remoteDir, OverthereFile localFile) {
        int stripComponentsDerived = stripComponents;
        Set<String> membersDerived = members;
        if (!this.isForceArchivedForFolder()) {
            stripComponentsDerived = stripComponents + 1;
            membersDerived = this.getMembersPathWithRootFolder(members, localFile.getName());
        }
        if (stripComponentsDerived > 0 || membersDerived != null && !membersDerived.isEmpty()) {
            Set<String> archivePaths = this.extractPathsUsingTarCommand(stripComponentsDerived, membersDerived);
            this.deleteFilesAndFolders(archivePaths, remoteDir);
        } else {
            this.deleteRemoteDirectory(localFile, remoteDir);
        }
    }

    protected void deleteOnlyRootFilesAndFoldersRecursiveOnTar(int stripComponents, Set<String> members, OverthereFile remoteDir, OverthereFile localFile) {
        int stripComponentsDerived = stripComponents;
        Set<String> membersDerived = members;
        if (!this.isForceArchivedForFolder()) {
            stripComponentsDerived = stripComponents + 1;
            membersDerived = this.getMembersPathWithRootFolder(members, localFile.getName());
        }
        if (stripComponentsDerived > 0 || membersDerived != null && !membersDerived.isEmpty()) {
            Set<String> archivePaths = this.extractPathsUsingTarCommand(stripComponentsDerived, membersDerived);
            this.deleteOnlyRootFilesAndFoldersRecursive(archivePaths, remoteDir);
        } else {
            this.deleteRemoteDirectory(localFile, remoteDir);
        }
    }

    protected boolean isTypeIsFileFolder(BaseDeployableFolderArtifact baseDeployableFolderArtifact) {
        return CopyUtil.isDeployableFileFolder((BaseDeployableFolderArtifact)baseDeployableFolderArtifact);
    }

    protected Set<String> getMembersPathWithRootFolder(Set<String> members, String srcFileName) {
        if (members == null || members.isEmpty()) {
            return members;
        }
        return members.stream().filter(member -> member.trim().length() > 0).map(member -> String.join((CharSequence)"/", srcFileName, member)).collect(Collectors.toSet());
    }

    protected void deleteOnlyRootFilesAndFoldersRecursive(Set<String> archivePaths, OverthereFile remoteDir) {
        logger.debug("[ArtifactDeleteStep] deleteOnlyRootFilesAndFoldersRecursive called. archivePaths: {}, remoteDir: {}", archivePaths, (Object)remoteDir.getPath());
        Set archivePathsWithoutRoot = archivePaths.stream().filter(path -> path != null && !path.trim().isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new));
        LinkedHashSet<String> processedPaths = new LinkedHashSet<String>();
        Set<String> archivePathsOnlyRoots = this.getRootFoldersAndFiles(archivePathsWithoutRoot);
        if (!archivePathsOnlyRoots.isEmpty()) {
            archivePathsOnlyRoots.forEach(path -> {
                boolean isFolderCanBeDeleted;
                OverthereFile remoteDirToDel = remoteDir.getFile(path);
                boolean bl = isFolderCanBeDeleted = remoteDirToDel.exists() && remoteDirToDel.isDirectory();
                if (isFolderCanBeDeleted) {
                    this.deleteFile(remoteDirToDel);
                    processedPaths.add(remoteDirToDel.getPath());
                    this.getCtx().logOutput("Deleted directory: " + remoteDirToDel.getPath());
                }
            });
            Set filesAndDirectoriesPathNotProcessedOnlyRoot = archivePathsWithoutRoot.stream().filter(path -> !processedPaths.contains(path)).filter(path -> path != null && !path.trim().isEmpty() && !path.contains("/")).collect(Collectors.toCollection(LinkedHashSet::new));
            filesAndDirectoriesPathNotProcessedOnlyRoot.forEach(path -> {
                boolean isFileCanBeDeleted;
                OverthereFile remoteDirFileToDelete = remoteDir.getFile(path);
                boolean bl = isFileCanBeDeleted = remoteDirFileToDelete != null && remoteDirFileToDelete.exists() && remoteDirFileToDelete.isFile();
                if (isFileCanBeDeleted) {
                    this.deleteFile(remoteDirFileToDelete);
                    processedPaths.add(remoteDirFileToDelete.getPath());
                }
            });
            this.processedPathShouldNotBeEmpty(remoteDir, processedPaths);
        } else {
            logger.debug("[ArtifactDeleteStep] No root files or folders found in archivePathsWithoutRoot: {}", (Object)archivePathsWithoutRoot);
            this.deleteFilesAndFolders(archivePathsWithoutRoot, remoteDir);
        }
    }

    protected final Set<String> getRootFoldersAndFiles(Set<String> archivePathsWithoutRoot) {
        return archivePathsWithoutRoot.stream().map(path -> path.contains("/") ? path.substring(0, path.indexOf("/")) : path).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    protected void deleteFilesAndFolders(Set<String> archivePaths, OverthereFile remoteDir) {
        logger.debug("[ArtifactDeleteStep]  deleteFilesAndFolders called. archivePaths: {}, remoteDir: {}", archivePaths, (Object)remoteDir.getPath());
        Set archivePathsWithoutRoot = archivePaths.stream().filter(path -> path != null && !path.trim().isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new));
        LinkedHashSet<String> processedPaths = new LinkedHashSet<String>();
        archivePathsWithoutRoot.forEach(path -> {
            boolean isFileCanBeDeleted;
            OverthereFile remoteDirFileToDelete = remoteDir.getFile(path);
            boolean bl = isFileCanBeDeleted = remoteDirFileToDelete != null && remoteDirFileToDelete.exists() && remoteDirFileToDelete.isFile();
            if (isFileCanBeDeleted) {
                this.deleteFile(remoteDirFileToDelete);
                processedPaths.add(remoteDirFileToDelete.getPath());
            }
        });
        Set processedRelativePaths = processedPaths.stream().map(absPath -> {
            String base = remoteDir.getPath();
            if (absPath.startsWith(base)) {
                String rel = absPath.substring(base.length());
                if (rel.startsWith("/")) {
                    rel = rel.substring(1);
                }
                return rel;
            }
            return absPath;
        }).collect(Collectors.toSet());
        Set filesAndDirectoriesPathNotProcessed = archivePathsWithoutRoot.stream().filter(path -> !processedRelativePaths.contains(path)).filter(path -> path != null && !path.trim().isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new));
        Set<String> rootDirectoriesPathNotProcessed = this.getRootFoldersAndFiles(filesAndDirectoriesPathNotProcessed);
        rootDirectoriesPathNotProcessed.forEach(path -> {
            boolean isFolderCanBeDeleted;
            OverthereFile remoteDirToDel = remoteDir.getFile(path);
            boolean bl = isFolderCanBeDeleted = remoteDirToDel.exists() && remoteDirToDel.isDirectory();
            if (isFolderCanBeDeleted) {
                if (this.targetPathSharedSubDirectories) {
                    this.deleteFolderIfEmpty(remoteDirToDel, processedPaths);
                } else {
                    this.deleteFile(remoteDirToDel);
                    processedPaths.add(remoteDirToDel.getPath());
                    this.getCtx().logOutput("Deleted directory: " + remoteDirToDel.getPath());
                }
            }
        });
        this.processedPathShouldNotBeEmpty(remoteDir, processedPaths);
    }

    private void processedPathShouldNotBeEmpty(OverthereFile remoteDir, Set<String> processedPaths) {
        if (processedPaths.isEmpty()) {
            this.getCtx().logError("No files or directories were deleted from " + remoteDir.getPath() + " on host " + String.valueOf(this.getContainer().getHost()));
            throw new RuntimeIOException("No files or directories were deleted from " + remoteDir.getPath() + " on host " + String.valueOf(this.getContainer().getHost()));
        }
        this.getCtx().logOutput("Deleted files and directories: " + String.join((CharSequence)", ", processedPaths) + " on host " + String.valueOf(this.getContainer().getHost()));
    }

    private void deleteRemoteDirectory(OverthereFile localFile, OverthereFile remoteDir) {
        for (OverthereFile file : localFile.listFiles()) {
            OverthereFile remoteFile = remoteDir.getFile(file.getName());
            if (this.targetPathSharedSubDirectories && file.isDirectory()) {
                if (remoteFile.exists()) {
                    this.deleteRemoteDirectory(file, remoteFile);
                    if (!remoteFile.listFiles().isEmpty()) continue;
                    this.deleteFile(remoteFile);
                    continue;
                }
                this.getCtx().logOutput(remoteFile.getPath() + " does not exist on host " + String.valueOf(this.getContainer().getHost()) + ". Will not perform delete.");
                continue;
            }
            this.deleteFile(remoteFile);
        }
    }

    protected void deleteTargetFile() {
        OverthereFile remoteFile = this.getRemoteConnection().getFile(this.targetDirectory);
        if (!Strings.nullToEmpty((String)this.targetFile).trim().isEmpty()) {
            remoteFile = remoteFile.getFile(this.targetFile);
        }
        this.deleteFile(remoteFile);
    }

    protected void deleteAdditionalFiles(Set<String> files) {
        for (String file : files) {
            OverthereFile remoteFile = this.getRemoteConnection().getFile(file);
            if (remoteFile.exists()) {
                this.getCtx().logOutput("Deleting " + remoteFile.getPath() + " on host " + String.valueOf(this.getContainer().getHost()));
                remoteFile.deleteRecursively();
                continue;
            }
            this.getCtx().logOutput(remoteFile.getPath() + " does not exist on host " + String.valueOf(this.getContainer().getHost()) + ". Will not perform delete.");
        }
    }

    protected void deleteFile(OverthereFile file) {
        this.getCtx().logOutput("Deleting " + file.getPath() + " on host " + String.valueOf(this.getContainer().getHost()));
        if (file.exists()) {
            file.deleteRecursively();
        } else {
            this.getCtx().logOutput(file.getPath() + " does not exist on host " + String.valueOf(this.getContainer().getHost()) + ". Will not perform delete.");
        }
    }

    protected void deleteFolderIfEmpty(OverthereFile folder, Set<String> processedPaths) {
        this.getCtx().logOutput("Deleting " + folder.getPath() + " on host " + String.valueOf(this.getContainer().getHost()));
        if (folder.exists()) {
            if (folder.listFiles().isEmpty()) {
                folder.deleteRecursively();
                this.getCtx().logOutput("Deleted directory: " + folder.getPath() + " on host " + String.valueOf(this.getContainer().getHost()));
                processedPaths.add(folder.getPath());
            }
        } else {
            this.getCtx().logOutput(folder.getPath() + " does not exist on host " + String.valueOf(this.getContainer().getHost()) + ". Will not perform delete.");
        }
    }

    private Set<String> extractPathsUsingTarCommand(Integer stripComponents, Set<String> members) {
        LocalFile sourceArtifactLocalFolder = (LocalFile)LocalFile.valueOf((File)((SourceArtifactFile)this.artifact.getFile()).getLocalFile());
        LocalFile sourceArtifactLocalFolderAsTar = this.folderAsTar(sourceArtifactLocalFolder);
        CmdLine cmdLine = new CmdLine();
        cmdLine.addArgument("tar");
        cmdLine.addArgument("-tf");
        cmdLine.addArgument(sourceArtifactLocalFolderAsTar.getPath());
        if (stripComponents != null && stripComponents > 0) {
            cmdLine.addArgument("--strip-components=" + stripComponents);
        }
        if (members != null && !members.isEmpty()) {
            for (String member : members) {
                if (member.trim().isEmpty()) continue;
                cmdLine.addArgument(member);
            }
        }
        LinkedHashSet<String> paths = new LinkedHashSet<String>();
        try {
            StringBuilder stdout = new StringBuilder();
            StringBuilder stderr = new StringBuilder();
            OverthereExecutionOutputHandler stdoutHandler = this.createOutputHandler(stdout);
            OverthereExecutionOutputHandler stderrHandler = this.createOutputHandler(stderr);
            int exitCode = this.artifact.getFile().getConnection().execute(stdoutHandler, stderrHandler, cmdLine);
            if (exitCode != 0) {
                throw new RuntimeException("Error executing tar command. Exit code: " + exitCode + ". Error: " + String.valueOf(stderr));
            }
            this.updateStrippedPaths(stripComponents, stdout, paths);
        }
        catch (Exception e) {
            this.getCtx().logError("Error executing while fetch using tar command: " + e.getMessage());
        }
        if (paths.isEmpty()) {
            this.getCtx().logOutput("No files found in the tar archive to delete:" + sourceArtifactLocalFolderAsTar.getPath() + " on host " + String.valueOf(this.getContainer().getHost()));
        }
        return paths;
    }

    private void updateStrippedPaths(Integer stripComponents, StringBuilder stdout, Set<String> paths) {
        List<String> allPaths = Arrays.asList(stdout.toString().split("\n"));
        for (String path : allPaths) {
            String[] components = path.split("/");
            if (stripComponents != null && stripComponents >= 0) {
                if (stripComponents >= components.length) continue;
                path = String.join((CharSequence)"/", Arrays.copyOfRange(components, (int)stripComponents, components.length));
            }
            paths.add(path);
        }
    }

    private OverthereExecutionOutputHandler createOutputHandler(final StringBuilder output) {
        return new OverthereExecutionOutputHandler(){

            public void handleLine(String line) {
                output.append(line).append("\n");
            }

            public void handleChar(char c) {
            }
        };
    }

    public String getDescription() {
        String description = super.getDescription();
        if (description == null) {
            return this.generateDescription();
        }
        return description;
    }

    @Override
    BaseDeployableFolderArtifact getBaseDeployableFolderArtifact() {
        return this.artifact instanceof BaseDeployableFolderArtifact ? (BaseDeployableFolderArtifact)this.artifact : null;
    }

    protected String generateDescription() {
        if (this.artifact != null) {
            return "Delete " + this.artifact.getName() + " from " + String.valueOf(this.getContainer().getHost());
        }
        if (!Strings.nullToEmpty((String)this.targetFile).trim().isEmpty()) {
            return "Delete file " + this.targetFile + " from directory " + this.targetDirectory + " on host " + String.valueOf(this.getContainer().getHost());
        }
        return "Delete directory " + this.targetDirectory + " from  " + String.valueOf(this.getContainer().getHost());
    }

    public String getTargetFile() {
        return this.targetFile;
    }

    public void setTargetFile(String targetFile) {
        this.targetFile = targetFile;
    }

    public boolean isTargetDirectoryShared() {
        return this.targetDirectoryShared;
    }

    public void setTargetDirectoryShared(boolean targetDirectoryShared) {
        this.targetDirectoryShared = targetDirectoryShared;
    }

    public Set<String> getDeleteAdditionalTargetFiles() {
        return this.deleteAdditionalTargetFiles;
    }

    public void setDeleteAdditionalTargetFiles(Set<String> deleteAdditionalTargetFiles) {
        this.deleteAdditionalTargetFiles = deleteAdditionalTargetFiles;
    }

    public void setTargetPathSharedSubDirectories(boolean targetPathSharedSubDirectories) {
        this.targetPathSharedSubDirectories = targetPathSharedSubDirectories;
    }
}

