/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.deploy.gitops.step;

import ai.digital.deploy.gitops.service.GitOpsServiceHolder;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.rules.StepMetadata;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlplatform.satellite.Satellite;
import com.xebialabs.xlplatform.satellite.SatelliteAware;

@StepMetadata(name="checkGitConnection")
public class CheckGitConnectionStep
implements SatelliteAware {
    private ConfigurationItem gitSource;

    public CheckGitConnectionStep() {
    }

    public CheckGitConnectionStep(ConfigurationItem gitSource) {
        this.gitSource = gitSource;
    }

    public String getDescription() {
        return "GitOps connectivity check";
    }

    public int getOrder() {
        return 50;
    }

    public Satellite getSatellite() {
        return null;
    }

    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        String id = this.gitSource.getId();
        ctx.logOutput("Started checking connection");
        try {
            GitOpsServiceHolder.getGitOpsService().checkConnection(this.gitSource);
            ctx.logOutput("GitOps connection check completed successfully");
            return StepExitCode.SUCCESS;
        }
        catch (Exception exception) {
            String errorMessage = exception.getCause() != null ? exception.getCause().getMessage() : exception.getMessage();
            ctx.logError(errorMessage, (Throwable)exception);
            return StepExitCode.FAIL;
        }
    }
}

