/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.deploy.gitops;

import ai.digital.deploy.gitops.step.CheckGitConnectionStep;
import ai.digital.deploy.gitops.step.GitCloneStep;
import ai.digital.deploy.gitops.step.GitOpsApplyStep;
import ai.digital.deploy.gitops.util.YamlHandler;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Delegate;
import com.xebialabs.deployit.plugin.api.udm.Parameters;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class GitOpsDelegate {
    private GitOpsDelegate() {
    }

    @Delegate(name="gitOpsCheckConnection")
    public static List<Step> checkConnection(ConfigurationItem item, String name, Map<String, String> args, Parameters params) {
        return Lists.newArrayList((Object[])new Step[]{new CheckGitConnectionStep(item)});
    }

    @Delegate(name="gitOpsImport")
    public static List<Step> importRepository(ConfigurationItem item, String name, Map<String, String> args, Parameters params) {
        String targetDirectory = (String)item.getProperty("targetPath");
        if (targetDirectory == null || targetDirectory.trim().isEmpty()) {
            targetDirectory = null;
        }
        ArrayList steps = Lists.newArrayList((Object[])new Step[]{new GitCloneStep(item, targetDirectory)});
        try {
            String repositoryPath = GitOpsDelegate.determineRepositoryPath(item, targetDirectory);
            steps.add(new GitOpsApplyStep(item, repositoryPath));
        }
        catch (Exception e) {
            System.out.println("Warning: Could not determine repository path for CI scanning: " + e.getMessage());
        }
        return steps;
    }

    public static String determineRepositoryPath(ConfigurationItem item, String targetDirectory) {
        if (targetDirectory != null && !targetDirectory.trim().isEmpty()) {
            String url = (String)item.getProperty("url");
            if (url == null) {
                throw new RuntimeException("Git URL not specified");
            }
            String orgPrefixedRepoName = YamlHandler.createOrgPrefixedRepositoryName(url);
            return targetDirectory + File.separator + orgPrefixedRepoName;
        }
        return null;
    }
}

