package ai.digital.deploy.gitops;

/**
 * Encapsulates Git user credentials for Git repository access.
 */
public class GitUserCredentials {
    private final String username;
    private final String password;

    public GitUserCredentials(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public String getUsername() {
        return username;
    }

    public String getPassword() {
        return password;
    }

    public boolean hasCredentials() {
        return username != null && !username.trim().isEmpty() && 
               password != null && !password.trim().isEmpty();
    }
}