package ai.digital.deploy.gitops.step;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.rules.StepMetadata;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import ai.digital.deploy.gitops.service.GitOpsServiceHolder;
import com.xebialabs.xlplatform.satellite.Satellite;
import com.xebialabs.xlplatform.satellite.SatelliteAware;

@StepMetadata(name = "checkGitConnection")
public class CheckGitConnectionStep implements SatelliteAware {
    
    private ConfigurationItem gitSource;
    
    // Default constructor required by XL Deploy rule scanning
    public CheckGitConnectionStep() {
    }
    
    public CheckGitConnectionStep(ConfigurationItem gitSource) {
        this.gitSource = gitSource;
    }
    
    @Override
    public String getDescription() {
        return "GitOps connectivity check";
    }
    
    @Override
    public int getOrder() {
        return 50;
    }
    
    @Override
    public Satellite getSatellite() {
        // Run locally on the XL Deploy server
        return null;
    }
    
    @Override
    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        String id = gitSource.getId();
        ctx.logOutput("Started checking connection");
        
        try {
            // Use the service layer to perform actual Git connectivity test
            // This mirrors exactly what Stitch does in CheckGitConnectionStep.scala
            GitOpsServiceHolder.getGitOpsService().checkConnection(gitSource);
            
            ctx.logOutput("GitOps connection check completed successfully");
            return StepExitCode.SUCCESS;
            
        } catch (Exception exception) {
            // Handle exceptions the same way as Stitch
            String errorMessage = exception.getCause() != null ? 
                exception.getCause().getMessage() : exception.getMessage();
            ctx.logError(errorMessage, exception);
            return StepExitCode.FAIL;
        }
    }
}