/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.deploy.gitops;

import ai.digital.deploy.gitops.GitOpsService;
import ai.digital.deploy.gitops.GitUserCredentials;
import ai.digital.deploy.gitops.util.YamlHandler;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LsRemoteCommand;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGitOpsService
implements GitOpsService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultGitOpsService.class);

    private CredentialsProvider createCredentialsProvider(GitUserCredentials credentials) {
        if (credentials != null && credentials.hasCredentials()) {
            return new UsernamePasswordCredentialsProvider(credentials.getUsername(), credentials.getPassword());
        }
        return null;
    }

    @Override
    public void testConnection(String url, String branch, GitUserCredentials credentials) {
        logger.info("Testing Git connection to: {}", (Object)url);
        try {
            Collection<Ref> refs;
            CredentialsProvider credentialsProvider = this.createCredentialsProvider(credentials);
            try {
                refs = this.listRemoteBranches(url, credentialsProvider);
            }
            catch (Exception listError) {
                throw new RuntimeException("Failed to list remote branches: " + listError.getMessage(), listError);
            }
            if (refs.isEmpty()) {
                throw new RuntimeException("No branches found in repository: " + url);
            }
            this.validateBranchExists(branch, refs, url);
            logger.info("Git connection test successful. Repository has {} branches", (Object)refs.size());
        }
        catch (Exception e) {
            logger.error("Git connection test failed for URL: {}", (Object)url, (Object)e);
            if (!(e instanceof RuntimeException)) {
                throw new RuntimeException("Failed to connect to Git repository: " + e.getMessage(), e);
            }
            throw e;
        }
    }

    private void validateBranchExists(String branch, Collection<Ref> refs, String url) {
        boolean branchExists;
        if (!(branch == null || branch.isEmpty() || branch.equals("main") || branch.equals("master") || (branchExists = refs.stream().anyMatch(ref -> ref.getName().endsWith("/" + branch))))) {
            logger.error("Branch '{}' not found in repository. Available branches: {}", (Object)branch, (Object)refs.stream().map(ref -> ref.getName()).toArray());
            throw new RuntimeException("Branch '" + branch + "' does not exist in repository: " + url);
        }
    }

    @Override
    public String cloneRepository(String url, String branch, GitUserCredentials credentials, String targetDirectory) {
        String string;
        block9: {
            logger.info("Cloning Git repository from: {} to: {}", (Object)url, (Object)targetDirectory);
            this.testConnection(url, branch, credentials);
            CredentialsProvider credentialsProvider = this.createCredentialsProvider(credentials);
            String orgPrefixedRepoName = YamlHandler.createOrgPrefixedRepositoryName(url);
            logger.debug("Using org-prefixed repository name: {}", (Object)orgPrefixedRepoName);
            String finalTargetDirectory = this.createUniqueTargetDirectory(targetDirectory, orgPrefixedRepoName, url);
            File targetDir = new File(finalTargetDirectory);
            this.ensureDirectoryExists(targetDir);
            CloneCommand cloneCommand = (CloneCommand)Git.cloneRepository().setURI(url).setDirectory(targetDir).setCredentialsProvider(credentialsProvider);
            if (branch != null && !branch.isEmpty()) {
                cloneCommand.setBranch(branch);
                logger.debug("Cloning specific branch: {}", (Object)branch);
            }
            Git git = cloneCommand.call();
            try {
                logger.info("Git repository cloned successfully to: {}", (Object)finalTargetDirectory);
                String currentBranch = git.getRepository().getBranch();
                logger.info("Currently on branch: {}", (Object)currentBranch);
                File gitDir = git.getRepository().getDirectory();
                logger.debug("Git directory: {}", (Object)gitDir.getAbsolutePath());
                string = finalTargetDirectory;
                if (git == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (git != null) {
                        try {
                            git.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    logger.error("Git clone failed for URL: {} to directory: {}", new Object[]{url, targetDirectory, e});
                    throw new RuntimeException("Failed to clone Git repository: " + e.getMessage(), e);
                }
            }
            git.close();
        }
        return string;
    }

    public static String extractFolderNameFromPath(String clonedPath) {
        if (clonedPath == null || clonedPath.trim().isEmpty()) {
            return "unknown";
        }
        try {
            File clonedDir = new File(clonedPath);
            String folderName = clonedDir.getName();
            return folderName != null && !folderName.trim().isEmpty() ? folderName : "unknown";
        }
        catch (Exception e) {
            int lastSlash;
            String normalizedPath = clonedPath.replace('\\', '/');
            if (normalizedPath.endsWith("/")) {
                normalizedPath = normalizedPath.substring(0, normalizedPath.length() - 1);
            }
            if ((lastSlash = normalizedPath.lastIndexOf(47)) >= 0 && lastSlash < normalizedPath.length() - 1) {
                return normalizedPath.substring(lastSlash + 1);
            }
            return "unknown";
        }
    }

    private String createUniqueTargetDirectory(String baseDirectory, String repoName, String repoUrl) {
        File targetDir;
        boolean created;
        File baseDir = new File(baseDirectory);
        if (!baseDir.exists() && !(created = baseDir.mkdirs())) {
            logger.warn("Failed to create base directory: {}", (Object)baseDirectory);
        }
        if (!(targetDir = new File(baseDir, repoName)).exists()) {
            return targetDir.getAbsolutePath();
        }
        if (targetDir.isDirectory() && targetDir.list() != null && targetDir.list().length == 0) {
            return targetDir.getAbsolutePath();
        }
        String timestamp = String.valueOf(System.currentTimeMillis());
        String timestampName = repoName + "_" + timestamp;
        File timestampDir = new File(baseDir, timestampName);
        logger.info("Directory {} exists and is not empty, using timestamp-based name: {}", (Object)repoName, (Object)timestampName);
        return timestampDir.getAbsolutePath();
    }

    @Override
    public String cloneRepository(ConfigurationItem gitSource, String targetDirectory) {
        if (gitSource == null) {
            throw new IllegalArgumentException("Git source cannot be null");
        }
        String url = (String)gitSource.getProperty("url");
        String branch = (String)gitSource.getProperty("branch");
        GitUserCredentials credentials = null;
        try {
            String username = (String)gitSource.getProperty("username");
            String password = (String)gitSource.getProperty("password");
            if (username != null && !username.trim().isEmpty() && password != null && !password.trim().isEmpty()) {
                credentials = new GitUserCredentials(username, password);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.cloneRepository(url, branch, credentials, targetDirectory);
    }

    @Override
    public String pullRepository(String repositoryPath, GitUserCredentials credentials) {
        String string;
        block9: {
            logger.info("Pulling Git repository at: {}", (Object)repositoryPath);
            this.validateRepositoryDirectory(repositoryPath);
            CredentialsProvider credentialsProvider = this.createCredentialsProvider(credentials);
            Git git = Git.open((File)new File(repositoryPath));
            try {
                String currentBranch = git.getRepository().getBranch();
                logger.info("Pulling updates for branch: {}", (Object)currentBranch);
                PullCommand pullCommand = git.pull();
                if (credentialsProvider != null) {
                    pullCommand.setCredentialsProvider(credentialsProvider);
                }
                PullResult result = pullCommand.call();
                string = this.handlePullResult(result, repositoryPath, git, credentialsProvider);
                if (git == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (git != null) {
                        try {
                            git.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    logger.error("Git pull failed for repository: {}", (Object)repositoryPath, (Object)e);
                    throw new RuntimeException("Failed to pull Git repository: " + e.getMessage(), e);
                }
            }
            git.close();
        }
        return string;
    }

    private void validateRepositoryDirectory(String repositoryPath) {
        File repoDir = new File(repositoryPath);
        if (!repoDir.exists() || !repoDir.isDirectory()) {
            throw new RuntimeException("Repository directory does not exist: " + repositoryPath);
        }
        if (!this.isGitRepository(repositoryPath)) {
            throw new RuntimeException("Directory is not a Git repository: " + repositoryPath);
        }
    }

    private String handlePullResult(PullResult result, String repositoryPath, Git git, CredentialsProvider credentialsProvider) throws Exception {
        if (result.isSuccessful()) {
            logger.info("Git pull completed successfully for: {}", (Object)repositoryPath);
            if (result.getMergeResult() != null) {
                MergeResult mergeResult = result.getMergeResult();
                logger.info("Merge status: {}", (Object)mergeResult.getMergeStatus());
                if (mergeResult.getConflicts() != null && !mergeResult.getConflicts().isEmpty()) {
                    logger.warn("Pull successful but had conflicts that were auto-resolved: {}", mergeResult.getConflicts().keySet());
                }
            }
            return repositoryPath;
        }
        MergeResult mergeResult = result.getMergeResult();
        if (mergeResult != null) {
            MergeResult.MergeStatus mergeStatus = mergeResult.getMergeStatus();
            logger.error("Pull failed with merge status: {}", (Object)mergeStatus);
            if (mergeStatus == MergeResult.MergeStatus.CONFLICTING) {
                return this.handleMergeConflicts(git, repositoryPath, mergeResult, credentialsProvider);
            }
            String errorMsg = "Git pull failed due to merge issues: " + String.valueOf(mergeStatus);
            logger.error(errorMsg);
            throw new RuntimeException(errorMsg);
        }
        String errorMsg = "Git pull failed: " + result.toString();
        logger.error(errorMsg);
        throw new RuntimeException(errorMsg);
    }

    @Override
    public String determineRepositoryPath(String url, String targetDirectory) {
        String orgPrefixedRepoName = YamlHandler.createOrgPrefixedRepositoryName(url);
        return this.createUniqueTargetDirectory(targetDirectory, orgPrefixedRepoName, url);
    }

    @Override
    public boolean isGitRepository(String directoryPath) {
        try {
            File repoDir = new File(directoryPath);
            if (!repoDir.exists() || !repoDir.isDirectory()) {
                return false;
            }
            File gitDir = new File(repoDir, ".git");
            return gitDir.exists() && gitDir.isDirectory();
        }
        catch (Exception e) {
            logger.debug("Error checking if directory is Git repository: {}", (Object)directoryPath, (Object)e);
            return false;
        }
    }

    private String handleMergeConflicts(Git git, String repositoryPath, MergeResult mergeResult, CredentialsProvider credentials) {
        logger.warn("Merge conflicts detected during pull operation");
        try {
            PullResult retryResult;
            Status status;
            if (mergeResult.getConflicts() != null) {
                logger.warn("Conflicted files:");
                mergeResult.getConflicts().keySet().forEach(file -> logger.warn("  - {}", file));
            }
            if ((status = git.status().call()).hasUncommittedChanges()) {
                logger.warn("Repository has uncommitted changes:");
                status.getConflicting().forEach(file -> logger.warn("  CONFLICTING: {}", file));
                status.getModified().forEach(file -> logger.warn("  MODIFIED: {}", file));
                status.getAdded().forEach(file -> logger.warn("  ADDED: {}", file));
            }
            logger.info("Attempting conflict resolution using 'theirs' strategy (remote wins)");
            git.reset().setMode(ResetCommand.ResetType.HARD).setRef("HEAD").call();
            logger.info("Reset to HEAD completed");
            PullCommand retryPull = git.pull().setStrategy(MergeStrategy.THEIRS);
            if (credentials != null) {
                retryPull.setCredentialsProvider(credentials);
            }
            if ((retryResult = retryPull.call()).isSuccessful()) {
                logger.info("Merge conflicts resolved using 'theirs' strategy");
                logger.warn("Local changes were overwritten by remote changes");
                return repositoryPath;
            }
            logger.warn("'Theirs' strategy failed, attempting hard reset to remote");
            return this.performHardResetToRemote(git, repositoryPath, credentials);
        }
        catch (Exception e) {
            logger.error("Failed to handle merge conflicts", (Throwable)e);
            return this.handleConflictResolutionFailure(repositoryPath, e);
        }
    }

    private String performHardResetToRemote(Git git, String repositoryPath, CredentialsProvider credentials) {
        try {
            logger.warn("Performing hard reset to remote HEAD - all local changes will be lost");
            if (credentials != null) {
                ((FetchCommand)git.fetch().setCredentialsProvider(credentials)).call();
            } else {
                git.fetch().call();
            }
            String currentBranch = git.getRepository().getBranch();
            String remoteBranch = "origin/" + currentBranch;
            git.reset().setMode(ResetCommand.ResetType.HARD).setRef(remoteBranch).call();
            logger.info("Hard reset to {} completed", (Object)remoteBranch);
            logger.warn("All local changes and commits were discarded");
            return repositoryPath;
        }
        catch (Exception e) {
            logger.error("Hard reset to remote failed", (Throwable)e);
            throw new RuntimeException("Unable to resolve merge conflicts: " + e.getMessage(), e);
        }
    }

    private String handleConflictResolutionFailure(String repositoryPath, Exception originalException) {
        String errorMessage = String.format("Merge conflict resolution failed for repository: %s\nManual intervention required:\n1. Navigate to: %s\n2. Resolve conflicts manually using: git status, git add, git commit\n3. Or reset repository: git reset --hard origin/<branch>\nOriginal error: %s", repositoryPath, repositoryPath, originalException.getMessage());
        logger.error(errorMessage);
        throw new RuntimeException(errorMessage, originalException);
    }

    private Collection<Ref> listRemoteBranches(String url, CredentialsProvider credentialsProvider) throws Exception {
        return ((LsRemoteCommand)Git.lsRemoteRepository().setRemote(url).setCredentialsProvider(credentialsProvider)).setHeads(true).call();
    }

    private void ensureDirectoryExists(Path directory) {
        try {
            if (!Files.exists(directory, new LinkOption[0])) {
                Files.createDirectories(directory, new FileAttribute[0]);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create directory: " + String.valueOf(directory), e);
        }
    }

    private void ensureDirectoryExists(File directory) {
        if (!directory.exists()) {
            boolean created = directory.mkdirs();
            if (!created) {
                throw new RuntimeException("Failed to create target directory: " + directory.getAbsolutePath());
            }
            logger.debug("Created target directory: {}", (Object)directory.getAbsolutePath());
        }
    }
}

