package com.xebialabs.deployit.plugins.lock;

import com.xebialabs.deployit.engine.spi.execution.ExecutionStateListener;
import com.xebialabs.deployit.engine.spi.execution.StepExecutionStateEvent;
import com.xebialabs.deployit.engine.spi.execution.TaskExecutionStateEvent;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.sql.lock.CiLockRepositoryHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.Serializable;
import java.util.Set;

public class LockCleanupListener implements ExecutionStateListener, Serializable {
	private static final Logger logger = LoggerFactory.getLogger(LockCleanupListener.class);

	private final Set<ConfigurationItem> cisToBeUnlocked;

	public LockCleanupListener(Set<ConfigurationItem> cisToBeUnlocked) {
		this.cisToBeUnlocked = cisToBeUnlocked;
	}

	@Override
	public void stepStateChanged(StepExecutionStateEvent event) {
		logger.info("Step event: {}", event);
	}

	@Override
	public void taskStateChanged(TaskExecutionStateEvent event) {
		logger.info("Task event: {}", event);

		switch(event.currentState()) {
			case CANCELLED:
			case DONE:
				TaskLockManager.clearLock(event.task().getId());
				CiLockRepositoryHolder.getCiLockRepository().unlock(cisToBeUnlocked, event.task().getId());
			default:
				break;
		}
	}

}
