/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugins.lock;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.RetryableStep;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugins.lock.LockCleanupListener;
import com.xebialabs.deployit.plugins.lock.TaskLockManager;
import com.xebialabs.deployit.repository.sql.lock.CiLockRepositoryHolder;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.dao.DeadlockLoserDataAccessException;

public class AcquireAllLocksStep
implements RetryableStep {
    private static final int ACQUIRE_LOCKS_ORDER = 2;
    private final Set<ConfigurationItem> cisToBeLocked;
    private final boolean enableRetry;
    private final int retryInSeconds;
    private final int retryLimit;
    private final boolean asyncRetry;

    public AcquireAllLocksStep(Set<ConfigurationItem> cisToBeLocked, boolean enableRetry, int retryInSeconds, int retryLimit, boolean asyncRetry) {
        this.cisToBeLocked = cisToBeLocked;
        this.enableRetry = enableRetry;
        this.retryInSeconds = retryInSeconds;
        this.retryLimit = retryLimit;
        this.asyncRetry = asyncRetry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StepExitCode execute(ExecutionContext context) throws Exception {
        ReentrantLock taskLock = TaskLockManager.getLock(context.getTask().getId());
        try {
            taskLock.lock();
            context.logOutput("Attempting to acquire locks on CIs " + String.valueOf(this.cisToBeLocked));
            boolean locked = CiLockRepositoryHolder.getCiLockRepository().lock(this.cisToBeLocked, context.getTask().getId());
            if (!locked && this.enableRetry) {
                if (this.asyncRetry) {
                    StepExitCode stepExitCode = StepExitCode.RETRY;
                    return stepExitCode;
                }
                locked = this.blockingRetry(context);
            }
            if (locked) {
                context.logOutput("All locks acquired");
                context.setAttribute("lockCleanupListener", (Object)new LockCleanupListener(this.cisToBeLocked));
                StepExitCode stepExitCode = StepExitCode.SUCCESS;
                return stepExitCode;
            }
            context.logError("Failed to acquire one or more locks");
            StepExitCode stepExitCode = StepExitCode.PAUSE;
            return stepExitCode;
        }
        catch (DeadlockLoserDataAccessException deadlockLoserDataAccessException) {
            context.logError("DeadlockLoserDataAccessException occurred while acquiring locks on CIs " + String.valueOf(this.cisToBeLocked) + ". Will retry in " + this.retryInSeconds + " seconds.", (Throwable)deadlockLoserDataAccessException);
            Thread.sleep((long)this.retryInSeconds * 1000L);
            StepExitCode stepExitCode = StepExitCode.RETRY;
            return stepExitCode;
        }
        finally {
            taskLock.unlock();
        }
    }

    private boolean blockingRetry(ExecutionContext context) throws Exception {
        boolean locked = false;
        for (int retryCount = 0; !locked && retryCount < this.retryLimit; ++retryCount) {
            context.logOutput("Will retry in " + this.retryInSeconds + " seconds");
            Thread.sleep((long)this.retryInSeconds * 1000L);
            context.logOutput("Attempting to acquire locks on CIs " + String.valueOf(this.cisToBeLocked));
            locked = CiLockRepositoryHolder.getCiLockRepository().lock(this.cisToBeLocked, context.getTask().getId());
        }
        return locked;
    }

    public String getDescription() {
        return "Acquiring locks for the following CIs: " + this.cisToBeLocked.toString();
    }

    public int getOrder() {
        return 2;
    }

    public Optional<Long> getStepRetryDelay(ExecutionContext context) {
        if (this.asyncRetry) {
            return Optional.of((long)this.retryInSeconds * 1000L);
        }
        return Optional.empty();
    }

    public Optional<Integer> getStepRetryCount(ExecutionContext context) {
        if (this.asyncRetry) {
            return Optional.of(this.retryLimit);
        }
        return Optional.empty();
    }

    public Optional<StepExitCode> stepRetryFailed(ExecutionContext context) {
        if (this.asyncRetry) {
            context.logError("Failed to acquire one or more locks");
            return Optional.of(StepExitCode.PAUSE);
        }
        return Optional.empty();
    }
}

