/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.policy;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.xebialabs.deployit.core.rest.xml.ArchivedTaskWriter;
import com.xebialabs.deployit.core.rest.xml.StepStateWriter;
import com.xebialabs.deployit.task.archive.ArchivedTask;
import com.xebialabs.xltype.serialization.xstream.XStreamReaderWriter;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import scala.Function1;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;

public final class TaskExporter$ {
    public static final TaskExporter$ MODULE$ = new TaskExporter$();

    public void export(Collection<ArchivedTask> tasks, String archivePath) {
        XStream writer = new XStream((HierarchicalStreamDriver)XStreamReaderWriter.HIERARCHICAL_STREAM_DRIVER);
        writer.registerConverter((Converter)new ArchivedTaskWriter());
        writer.registerConverter((Converter)new StepStateWriter());
        writer.aliasType("task", ArchivedTask.class);
        if (archivePath == null) {
            throw new Exception("Property 'archivePath' not defined, please define a valid path for the export.");
        }
        Path archivedTaskPath = Paths.get(archivePath, new String[0]);
        Path archiveDir = archivedTaskPath.getParent();
        Object object = !Files.exists(archiveDir, new LinkOption[0]) ? Files.createDirectories(archiveDir, new FileAttribute[0]) : BoxedUnit.UNIT;
        try (ZipOutputStream zip = new ZipOutputStream(new FileOutputStream(archivedTaskPath.toFile()));){
            CollectionConverters$.MODULE$.CollectionHasAsScala(tasks).asScala().foreach((Function1 & Serializable)task -> {
                TaskExporter$.$anonfun$export$1(zip, writer, task);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ void $anonfun$export$1(ZipOutputStream zip$1, XStream writer$1, ArchivedTask task) {
        String taskFileName = task.getStartDate().toString("yyyy/MM/dd") + "/" + task.getId() + ".xml";
        zip$1.putNextEntry(new ZipEntry(taskFileName));
        writer$1.toXML((Object)task, (OutputStream)zip$1);
        zip$1.closeEntry();
    }

    private TaskExporter$() {
    }
}

