package com.xebialabs.deployit.plugin.python;

import java.util.Map;

import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.remoting.inspection.DeployedInspectionHelper;

@SuppressWarnings("rawtypes")
public class PythonDeployedInspectionHelper<C extends PythonManagedContainer, D extends PythonManagedDeployed>extends DeployedInspectionHelper<C,D> {

    public PythonDeployedInspectionHelper(Class<C> containerSuperClass, Class<D> deployedSuperClass) {
        super(containerSuperClass, deployedSuperClass);
    }

    @Override
    protected Step createInspectionStep(C container, D deployed, String scriptName, Map<String, Object> varsCtx, String description) {
        return new PythonInspectionStep(container, container.getManagingContainer(), scriptName, varsCtx, description);
    }
}
